/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.ConnectionException;

public class SQLConnections {
    static boolean lock(Connection connection) {
        return LockManager.lock((Connection)connection);
    }

    static void unlock(Connection connection) {
        LockManager.unlock((Connection)connection);
    }

    static boolean checkLock(Connection connection) {
        return LockManager.checkLock((Connection)connection);
    }

    static String getDisplayName(String string) {
        return Connections.getDisplayName((String)string);
    }

    static Properties getConnectionInfo(String string) {
        return Connections.getInstance().getConnectionInfo(string);
    }

    static String createPrivateConnection(String string, Properties properties) {
        String string2 = null;
        try {
            string2 = Connections.getInstance().createPrivateConnection(string, properties);
        }
        catch (RuntimeException | ConnectionException throwable) {
            SQLConnections.getLogger().log(Level.WARNING, "Unable to remove private connection name: " + string2, throwable);
        }
        return string2;
    }

    static void removePrivateConnection(String string) {
        try {
            Connections.getInstance().removePrivateConnection(string);
        }
        catch (RuntimeException | ConnectionException throwable) {
            SQLConnections.getLogger().log(Level.WARNING, "Unable to remove private connection name: " + string, throwable);
        }
    }

    static Connection getConnection(String string, boolean bl) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string, bl);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable == null) {
                throwable = dBException;
            }
            throw new DXException(throwable);
        }
        return connection;
    }

    static Connection cloneConnection(Connection connection) {
        Connection connection2 = null;
        try {
            connection2 = Connections.getInstance().cloneConnection(connection);
        }
        catch (ConnectionException connectionException) {
            Throwable throwable = connectionException.getCause();
            if (throwable == null) {
                throwable = connectionException;
            }
            throw new DXException(throwable);
        }
        return connection2;
    }

    static String getConnectionName(Connection connection) {
        return Connections.getInstance().getConnectionName(connection);
    }

    static boolean isConnectionAlive(String string) {
        boolean bl = false;
        try {
            Database database = Connections.getInstance().getDatabase(string);
            if (database != null) {
                bl = database.isConnectionAlive();
            } else {
                SQLConnections.getLogger().log(Level.WARNING, "Database object not found, assume connection died: {0}", string);
            }
        }
        catch (DBException dBException) {
            SQLConnections.getLogger().log(Level.WARNING, "Database object not found, assume connection died: " + string, dBException);
        }
        return bl;
    }

    static void closeConnection(String string) {
        try {
            Connections.getInstance().closeConnection(string);
        }
        catch (Exception exception) {
            SQLConnections.getLogger().log(Level.WARNING, "Error in closing connection: " + string, exception);
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(SQLConnections.class.getName());
    }

    private SQLConnections() {
    }
}

