/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.observable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;
import oracle.dbtools.raptor.metrics.observable.ItemChangeAdapter;

abstract class StructuredItemChangeAdapter
extends ItemChangeAdapter<DXTableChanges> {
    private final SimpleBooleanProperty updating = new SimpleBooleanProperty();
    private final List<String> derivedColumnNames;
    private final Map<DXTableChanges.Key, CachedRow> cachedRowMap;
    private long previousTStamp;

    StructuredItemChangeAdapter(String string) {
        this.derivedColumnNames = string != null ? Arrays.asList(string.split("\\s*\\,\\s*")) : null;
        this.cachedRowMap = string != null ? new TreeMap() : null;
    }

    BooleanExpression getUpdating() {
        return this.updating;
    }

    @Override
    void onChange(long l, DXTableChanges dXTableChanges) {
        if (this.derivedColumnNames != null) {
            dXTableChanges = this.updateChangeObject(l, dXTableChanges);
        }
        if (dXTableChanges != null) {
            this.updating.set(true);
            if (!this.isAvailable()) {
                this.clearStructuredProperty();
            }
            this.updateStructuredProperty(dXTableChanges);
            this.setAvailable();
            this.updating.set(false);
        }
    }

    abstract void clearStructuredProperty();

    abstract void updateStructuredProperty(DXTableChanges var1);

    private DXTableChanges updateChangeObject(long l, DXTableChanges dXTableChanges) {
        Object object;
        ArrayList<DXTableChanges.Row> arrayList = new ArrayList<DXTableChanges.Row>();
        ArrayList<DXTableChanges.Row> arrayList2 = new ArrayList<DXTableChanges.Row>();
        for (DXTableChanges.Row object22 : dXTableChanges.getChangedRows()) {
            object = this.cachedRowMap.get(object22.getRowKey());
            ((CachedRow)object).update(object22);
        }
        for (DXTableChanges.Row row : dXTableChanges.getAddedRows()) {
            this.cachedRowMap.put(row.getRowKey(), new CachedRow(row));
        }
        List<DXTableChanges.Key> list = dXTableChanges.getRemovedRowKeys();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (DXTableChanges.Key)iterator.next();
            this.cachedRowMap.remove(object);
        }
        double d = (double)(l - this.previousTStamp) / 1000.0;
        for (CachedRow cachedRow : this.cachedRowMap.values()) {
            cachedRow.scan(d, arrayList, arrayList2);
        }
        this.previousTStamp = l;
        Object object2 = null;
        if (!(arrayList.isEmpty() && arrayList2.isEmpty() && list.isEmpty())) {
            object2 = new DXTableChanges(arrayList, arrayList2, list);
        }
        return object2;
    }

    private class CachedRow {
        private DXTableChanges.Row rawRow;
        private DXTableChanges.Row newRawRow;
        private Map<String, Double> derivedValues;

        CachedRow(DXTableChanges.Row row) {
            this.newRawRow = row;
            for (String string : StructuredItemChangeAdapter.this.derivedColumnNames) {
                Double d = row.getCellValue(string, Double.class);
                if (d != null) continue;
                Logger.getLogger(StructuredItemChangeAdapter.class.getName()).log(Level.WARNING, "Column name ''{0}'' cannot be derived because there is no real-valued column of this name", new Object[]{string});
            }
        }

        void update(DXTableChanges.Row row) {
            this.rawRow = this.newRawRow;
            this.newRawRow = row;
        }

        void scan(double d, List<DXTableChanges.Row> list, List<DXTableChanges.Row> list2) {
            if (this.rawRow != null) {
                Object object;
                boolean bl = this.derivedValues == null;
                boolean bl2 = false;
                HashMap<String, Double> hashMap = new HashMap<String, Double>();
                for (String object3 : StructuredItemChangeAdapter.this.derivedColumnNames) {
                    Double d2;
                    Double d3 = this.newRawRow.getCellValue(object3, Double.class);
                    object = this.rawRow.getCellValue(object3, Double.class);
                    if (d3 == null || object == null) continue;
                    double d4 = (d3 - (Double)object) / d;
                    Double d5 = d2 = this.derivedValues != null ? this.derivedValues.get(object3) : null;
                    if (d2 == null || d4 != d2) {
                        bl2 = true;
                    }
                    hashMap.put(object3, d4);
                }
                if (!bl2) {
                    for (String string : this.newRawRow.getCellNames()) {
                        if (hashMap.containsKey(string)) continue;
                        Object object2 = this.newRawRow.getCellValue(string, Object.class);
                        object = this.rawRow.getCellValue(string, Object.class);
                        if (object == null || object.equals(object2)) continue;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    HashMap hashMap2 = new HashMap();
                    for (String string : this.newRawRow.getCellNames()) {
                        if (hashMap.containsKey(string)) {
                            hashMap2.put(string, hashMap.get(string));
                            continue;
                        }
                        hashMap2.put(string, this.newRawRow.getCellValue(string, Object.class));
                    }
                    DXTableChanges.Row row = new DXTableChanges.Row(this.newRawRow.getRowKey(), hashMap2);
                    if (bl) {
                        list.add(row);
                    } else {
                        list2.add(row);
                    }
                }
                this.derivedValues = hashMap;
            }
            this.rawRow = this.newRawRow;
        }
    }
}

