/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.observable.DXRow;

public abstract class TreeTableCellFactory<L extends TreeTableCell<DXRow, ?>>
extends AbstractCellFactory<TreeTableColumn<DXRow, Object>, L> {
    private final Map<Integer, L> cellMap = new WeakHashMap<Integer, L>();

    @Override
    protected DXRow getRow(L l) {
        TreeItem treeItem = l.getTreeTableView().getTreeItem(l.getIndex());
        if (treeItem != null) {
            return (DXRow)treeItem.getValue();
        }
        return null;
    }

    @Override
    protected int getRowIndex(L l) {
        return l.getTreeTableRow().getIndex();
    }

    @Override
    protected int getSelectedIndex(L l) {
        return l.getTreeTableView().getSelectionModel().getSelectedIndex();
    }

    @Override
    protected L getCell(int n) {
        return (L)((TreeTableCell)this.cellMap.get(n));
    }

    @Override
    protected void initCell(L l) {
        ChangeListener changeListener = (observableValue, number, number2) -> this.updateCellMap(l, (Number)number, (Number)number2);
        l.tableRowProperty().addListener((observableValue, treeTableRow, treeTableRow2) -> {
            Integer n = null;
            Integer n2 = null;
            if (treeTableRow != null) {
                n = treeTableRow.getIndex();
                treeTableRow.indexProperty().removeListener(changeListener);
            }
            if (treeTableRow2 != null) {
                n2 = treeTableRow2.getIndex();
                treeTableRow2.indexProperty().addListener(changeListener);
            }
            this.updateCellMap(l, n, n2);
        });
    }

    private void updateCellMap(L l, Number number, Number number2) {
        int n;
        int n2 = number != null ? number.intValue() : -1;
        int n3 = n = number2 != null ? number2.intValue() : -1;
        if (n2 != n) {
            if (n2 >= 0) {
                this.cellMap.remove(n2);
            }
            if (n >= 0) {
                this.cellMap.put(n, l);
            }
        }
    }
}

