/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AbstractTreeControl;
import oracle.dbtools.raptor.metrics.control.BezierComponent;
import oracle.dbtools.raptor.metrics.control.Tree;
import oracle.dbtools.raptor.metrics.control.TreeEdge;
import oracle.dbtools.raptor.metrics.control.TreeVertex;
import oracle.dbtools.raptor.metrics.facet.AbstractGraphMonitor;
import oracle.dbtools.raptor.metrics.facet.TreeExpansionType;
import oracle.dbtools.raptor.metrics.observable.DXRow;

public class TreeMonitor
extends AbstractGraphMonitor<Tree<DXRow, TreeVertex<DXRow>, TreeEdge<DXRow>>, TreeVertex<DXRow>, TreeEdge<DXRow>, BezierComponent> {
    private final ObjectProperty<TreeExpansionType> expansionTypeProperty = new SimpleObjectProperty((Object)this, "expansionType", (Object)TreeExpansionType.ROOT_EXPANDED);

    public TreeMonitor() {
        this.init(new Listener());
    }

    public TreeExpansionType getExpansionType() {
        return (TreeExpansionType)((Object)this.expansionTypeProperty.get());
    }

    public void setExpansionType(TreeExpansionType treeExpansionType) {
        this.expansionTypeProperty.set((Object)treeExpansionType);
    }

    public ObjectProperty<TreeExpansionType> expansionTypeProperty() {
        return this.expansionTypeProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return AbstractTreeControl.class;
    }

    @Override
    protected TreeVertex<DXRow> createVertex(DXRow dXRow) {
        return new TreeVertex<DXRow>();
    }

    @Override
    protected TreeEdge<DXRow> createEdge(TreeVertex<DXRow> treeVertex, TreeVertex<DXRow> treeVertex2, DXRow dXRow) {
        return new TreeEdge<DXRow>(treeVertex, treeVertex2);
    }

    @Override
    protected void resetModel(AbstractGraphControl<DXRow, Tree<DXRow, TreeVertex<DXRow>, TreeEdge<DXRow>>, TreeVertex<DXRow>, TreeEdge<DXRow>, BezierComponent> abstractGraphControl) {
        Tree<DXRow, TreeVertex<DXRow>, TreeEdge<DXRow>> tree = abstractGraphControl.getGraph();
        boolean bl = tree.getEdges().isEmpty();
        super.resetModel(abstractGraphControl);
        if (bl) {
            switch (this.getExpansionType()) {
                case ROOT_EXPANDED: {
                    TreeVertex<DXRow> treeVertex = tree.getRoot();
                    if (treeVertex == null) break;
                    tree.getRoot().setExpanded(true);
                    break;
                }
                case EXPANDED: {
                    for (TreeVertex treeVertex : tree.getVertices()) {
                        treeVertex.setExpanded(true);
                    }
                    break;
                }
            }
        }
    }

    protected class Listener
    extends AbstractGraphMonitor.Listener {
        protected Listener() {
        }
    }
}

