/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.sqlcl.commands.dg.DgCmdConfig;
import oracle.dbtools.sqlcl.commands.dg.DgCmdRole;
import oracle.dbtools.sqlcl.commands.dg.DgUtils;
import oracle.dbtools.sqlcl.commands.dg.Messages;

public class DgCommand
extends CommandListener
implements IHelp,
SQLCLService {
    public static String COMMAND = "DG";
    protected static final Logger LOGGER = Logger.getLogger(DgCommand.class.getName());
    protected static final String SHOW = "SHOW";
    protected static final String ADD = "ADD";
    protected static final String ENABLE = "ENABLE";
    protected static final String DISABLE = "DISABLE";
    protected static final String REMOVE = "REMOVE";
    protected static final String EDIT = "EDIT";
    protected static final String CREATE = "CREATE";
    protected static final String FAILOVER = "FAILOVER";
    protected static final String REINSTATE = "REINSTATE";
    protected static final String SWITCHOVER = "SWITCHOVER";
    protected static final String SET = "SET";
    protected static final String HELP = "HELP";
    static String addMemStr = COMMAND + "\\s+ADD\\s+(database|far_sync|recovery_appliance)\\s+(\\S+)\\s+as\\s+connect\\s+identifier\\s+is\\s+(\\S+)\\s*$";
    static String createCfgStr = COMMAND + "\\s+CREATE\\s+configuration\\s+(\\S+)\\s+as\\s+primary\\s+database\\s+is\\s+(\\S+)\\s+connect\\s+identifier\\s+is\\s+(\\S+)(\\s+include\\s+current\\s+destinations)?\\s*$";
    static String disableCfgStr = COMMAND + "\\s+DISABLE\\s+configuration\\s*$";
    static String disableMemberStr = COMMAND + "\\s+DISABLE\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s*$";
    static String disableFSFOStr = COMMAND + "\\s+DISABLE\\s+fast_start\\s+failover\\s*$";
    static String editCfgPropStr = COMMAND + "\\s+EDIT\\s+configuration\\s+set\\s+property\\s+(\\S+)\\s*=\\s*(.*)$";
    static String editMemPropStr = COMMAND + "\\s+EDIT\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s+set\\s+property\\s+(\\S+)\\s*=\\s*(.*)$";
    static String editMemStateStr = COMMAND + "\\s+EDIT\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s+set\\s+state\\s*=\\s*(.*)$";
    static String enableCfgStr = COMMAND + "\\s+ENABLE\\s+configuration\\s*$";
    static String enableFSFOStr = COMMAND + "\\s+ENABLE\\s+fast_start\\s+failover\\s*$";
    static String enableMemberStr = COMMAND + "\\s+ENABLE\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s*$";
    static String failoverStr = COMMAND + "\\s+FAILOVER\\s+to+\\s+(\\S+)\\s*(immediate|complete)?\\s*$";
    static String reinstateStr = COMMAND + "\\s+REINSTATE\\s+database\\s+(.+)\\s*$";
    static String removeCfgStr = COMMAND + "\\s+REMOVE\\s+configuration(\\s+preserve\\s+destination)?\\s*$";
    static String removeMemStr = COMMAND + "\\s+remove\\s+(database|far_sync|member)\\s+(\\S+)(\\s+preserve\\s+destinations)?\\s*$";
    static String resetCfgTagStr = COMMAND + "\\s+EDIT\\s+configuration\\s+reset\\s+tag(\\s+(\\S+))?\\s*$";
    static String resetMemTagStr = COMMAND + "\\s+EDIT\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s+reset\\s+tag(\\s+(\\S+))?\\s*$";
    static String setStr = COMMAND + "\\s+SET\\s+(\\S+)\\s+(\\S+)\\s*$";
    static String setCfgTagStr = COMMAND + "\\s+EDIT\\s+configuration\\s+set\\s+tag\\s+(\\S+)\\s*=\\s*(.*)$";
    static String setMemTagStr = COMMAND + "\\s+EDIT\\s+(database|far_sync|recovery_appliance|member)\\s+(\\S+)\\s+set\\s+tag\\s+(\\S+)?\\s*=\\s*(.*)$";
    static String showCfgStr = COMMAND + "\\s+show\\s+configuration(\\s+(\\S+))?\\s*$";
    static String showCfgTagStr = COMMAND + "\\s+show\\s+configuration\\s+tag(\\s+(\\S+))?\\s*$";
    static String showMemStr = COMMAND + "\\s+show\\s+(database|far_sync|member)\\s+(\\S+)(\\s+(\\S+))?\\s*$";
    static String showMemTagStr = COMMAND + "\\s+show\\s+(database|far_sync|member)\\s+(\\S+)\\s+tag(\\s+(\\S+))?\\s*$";
    static String switchoverStr = COMMAND + "\\s+SWITCHOVER\\s+to+\\s+(\\S+)(\\s+wait\\s*([0-9]+)?)?\\s*$";
    static Pattern pnAddMem = Pattern.compile(addMemStr, 2);
    static Pattern pnCreateCfg = Pattern.compile(createCfgStr, 2);
    static Pattern pnDisableCfg = Pattern.compile(disableCfgStr, 2);
    static Pattern pnDisableMem = Pattern.compile(disableMemberStr, 2);
    static Pattern pnDisableFSFO = Pattern.compile(disableFSFOStr, 2);
    static Pattern pnEditCfgProp = Pattern.compile(editCfgPropStr, 2);
    static Pattern pnEditMemProp = Pattern.compile(editMemPropStr, 2);
    static Pattern pnEditMemState = Pattern.compile(editMemStateStr, 2);
    static Pattern pnEnableCfg = Pattern.compile(enableCfgStr, 2);
    static Pattern pnEnableFSFO = Pattern.compile(enableFSFOStr, 2);
    static Pattern pnEnableMem = Pattern.compile(enableMemberStr, 2);
    static Pattern pnFailover = Pattern.compile(failoverStr, 2);
    static Pattern pnReinsate = Pattern.compile(reinstateStr, 2);
    static Pattern pnRemoveCfg = Pattern.compile(removeCfgStr, 2);
    static Pattern pnRemoveMem = Pattern.compile(removeMemStr, 2);
    static Pattern pnResetCfgTag = Pattern.compile(resetCfgTagStr, 2);
    static Pattern pnResetMemTag = Pattern.compile(resetMemTagStr, 2);
    static Pattern pnSet = Pattern.compile(setStr, 2);
    static Pattern pnSetCfgTag = Pattern.compile(setCfgTagStr, 2);
    static Pattern pnSetMemTag = Pattern.compile(setMemTagStr, 2);
    static Pattern pnShowCfg = Pattern.compile(showCfgStr, 2);
    static Pattern pnShowCfgTag = Pattern.compile(showCfgTagStr, 2);
    static Pattern pnShowMem = Pattern.compile(showMemStr, 2);
    static Pattern pnShowMemTag = Pattern.compile(showMemTagStr, 2);
    static Pattern pnSwitchover = Pattern.compile(switchoverStr, 2);

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("dgcommand - begin");
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        LOGGER.info("dgcommand - end");
    }

    public String getCommand() {
        return COMMAND;
    }

    public String getHelp() {
        String BUNDLE_NAME = "oracle.dbtools.sqlcl.commands.dg.HelpMessages";
        return HelpMessages.getString((String)this.getCommand(), (String)BUNDLE_NAME);
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return Messages.getString("DGCmd.EXTENSIONDESCRIPTION");
    }

    public String getExtensionName() {
        String name = "Data Guard Command";
        return "Data Guard Command";
    }

    public String getExtensionVersion() {
        return Messages.getString("DGCmd.VERSION");
    }

    public boolean handleEvent(Connection sqlConn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String dg_cmd;
        if (!cmd.getLoweredTrimmedSQL().startsWith(COMMAND.toLowerCase())) {
            return false;
        }
        String sql = cmd.getSql().trim();
        String[] tokens = sql.split(" ");
        if (tokens.length == 1) {
            ctx.write(Messages.getString("DGCmd.SYNTAX"));
            return true;
        }
        switch (dg_cmd = tokens[1].trim().toUpperCase()) {
            case "HELP": {
                ctx.write(this.getHelp());
                return true;
            }
            case "SHOW": {
                Matcher mShowCfg = pnShowCfg.matcher(sql);
                Matcher mShowMem = pnShowMem.matcher(sql);
                Matcher mShowCfgTag = pnShowCfgTag.matcher(sql);
                Matcher mShowMemTag = pnShowMemTag.matcher(sql);
                if (mShowCfgTag.matches()) {
                    String tag = DgUtils.trimQuotes(mShowCfgTag.group(2));
                    new DgCmdConfig(ctx, sqlConn).runShowTag(null, tag);
                    return true;
                }
                if (mShowCfg.matches()) {
                    String prop = DgUtils.trimQuotes(mShowCfg.group(2));
                    if (prop != null) {
                        if (!prop.equalsIgnoreCase("verbose")) {
                            new DgCmdConfig(ctx, sqlConn).runShowConfigProp(prop);
                        } else {
                            new DgCmdConfig(ctx, sqlConn).runShowConfig(true);
                        }
                    } else {
                        new DgCmdConfig(ctx, sqlConn).runShowConfig(false);
                    }
                    return true;
                }
                if (mShowMemTag.matches()) {
                    String member = DgUtils.trimQuotes(mShowMemTag.group(2));
                    String tag = DgUtils.trimQuotes(mShowMemTag.group(4));
                    new DgCmdConfig(ctx, sqlConn).runShowTag(member, tag);
                    return true;
                }
                if (mShowMem.matches()) {
                    String arg1 = DgUtils.trimQuotes(mShowMem.group(2));
                    String arg2 = DgUtils.trimQuotes(mShowMem.group(4));
                    LOGGER.info("show database");
                    if ("verbose".equalsIgnoreCase(arg1)) {
                        if (arg2 != null) {
                            new DgCmdConfig(ctx, sqlConn).runShowMember(arg2, true);
                            return true;
                        }
                    } else if (arg1 != null) {
                        if (arg2 != null) {
                            new DgCmdConfig(ctx, sqlConn).runShowMemberProp(arg1, arg2);
                        } else {
                            new DgCmdConfig(ctx, sqlConn).runShowMember(arg1, false);
                        }
                        return true;
                    }
                }
                LOGGER.info("show no matches");
                break;
            }
            case "ADD": {
                Matcher m = pnAddMem.matcher(sql);
                if (!m.matches()) break;
                String mtype = DgUtils.trimQuotes(m.group(1));
                String mname = DgUtils.trimQuotes(m.group(2));
                String ci = DgUtils.trimQuotes(m.group(3));
                if (mtype == null) break;
                new DgCmdConfig(ctx, sqlConn).runAddMember(mname, ci, mtype);
                return true;
            }
            case "ENABLE": {
                Matcher mCfg = pnEnableCfg.matcher(sql);
                Matcher mMem = pnEnableMem.matcher(sql);
                Matcher mFSFO = pnEnableFSFO.matcher(sql);
                if (mCfg.matches()) {
                    new DgCmdConfig(ctx, sqlConn).runEnableConfig();
                    return true;
                }
                if (mMem.matches()) {
                    String mname = DgUtils.trimQuotes(mMem.group(2));
                    new DgCmdConfig(ctx, sqlConn).runEnableMember(mname);
                    return true;
                }
                if (!mFSFO.matches()) break;
                new DgCmdConfig(ctx, sqlConn).runEnableFSFO();
                return true;
            }
            case "DISABLE": {
                Matcher mCfg = pnDisableCfg.matcher(sql);
                Matcher mMem = pnDisableMem.matcher(sql);
                Matcher mFSFO = pnDisableFSFO.matcher(sql);
                LOGGER.info("sql: " + sql);
                if (mCfg.matches()) {
                    new DgCmdConfig(ctx, sqlConn).runDisableConfig();
                    return true;
                }
                if (mMem.matches()) {
                    String mname = DgUtils.trimQuotes(mMem.group(2));
                    new DgCmdConfig(ctx, sqlConn).runDisableMember(mname);
                    return true;
                }
                if (!mFSFO.matches()) break;
                new DgCmdConfig(ctx, sqlConn).runDisableFSFO();
                return true;
            }
            case "REMOVE": {
                Matcher mCfg = pnRemoveCfg.matcher(sql);
                Matcher mMem = pnRemoveMem.matcher(sql);
                if (mCfg.matches()) {
                    boolean pdest = mCfg.group(1) != null;
                    new DgCmdConfig(ctx, sqlConn).runRemoveConfig(pdest);
                    return true;
                }
                if (!mMem.matches()) break;
                String mname = DgUtils.trimQuotes(mMem.group(2));
                int p_dest = mMem.group(3) == null ? 0 : 1;
                new DgCmdConfig(ctx, sqlConn).runRemoveMember(mname, p_dest);
                return true;
            }
            case "EDIT": {
                Matcher mEditCfgProp = pnEditCfgProp.matcher(sql);
                Matcher mEditMemProp = pnEditMemProp.matcher(sql);
                Matcher mEditMemState = pnEditMemState.matcher(sql);
                Matcher mSetCfgTag = pnSetCfgTag.matcher(sql);
                Matcher mSetMemTag = pnSetMemTag.matcher(sql);
                Matcher mResetCfgTag = pnResetCfgTag.matcher(sql);
                Matcher mResetMemTag = pnResetMemTag.matcher(sql);
                LOGGER.info(String.format("edit command: '%s'", sql));
                if (mEditCfgProp.matches()) {
                    String prop = DgUtils.trimQuotes(mEditCfgProp.group(1));
                    String val = DgUtils.trimQuotes(mEditCfgProp.group(2));
                    new DgCmdConfig(ctx, sqlConn).runEditConfigProp(prop, val);
                    return true;
                }
                if (mEditMemProp.matches()) {
                    String mname = DgUtils.trimQuotes(mEditMemProp.group(2));
                    String prop = DgUtils.trimQuotes(mEditMemProp.group(3));
                    String val = DgUtils.trimQuotes(mEditMemProp.group(4));
                    LOGGER.info(String.format("edit member property: '%s', '%s', '%s'", mname, prop, val));
                    new DgCmdConfig(ctx, sqlConn).runEditMemberProp(mname, prop, val);
                    return true;
                }
                if (mEditMemState.matches()) {
                    String mname = DgUtils.trimQuotes(mEditMemState.group(2));
                    String val = DgUtils.trimQuotes(mEditMemState.group(3));
                    LOGGER.info(String.format("edit member state: '%s', '%s'", mname, val));
                    new DgCmdConfig(ctx, sqlConn).runEditMemberState(mname, val);
                    return true;
                }
                if (mSetCfgTag.matches()) {
                    String tag = DgUtils.trimQuotes(mSetCfgTag.group(1));
                    String val = DgUtils.trimQuotes(mSetCfgTag.group(2));
                    new DgCmdConfig(ctx, sqlConn).runEditTag(null, tag, val);
                    return true;
                }
                if (mSetMemTag.matches()) {
                    String mem = DgUtils.trimQuotes(mSetMemTag.group(2));
                    String tag = DgUtils.trimQuotes(mSetMemTag.group(3));
                    String val = DgUtils.trimQuotes(mSetMemTag.group(4));
                    new DgCmdConfig(ctx, sqlConn).runEditTag(mem, tag, val);
                    return true;
                }
                if (mResetCfgTag.matches()) {
                    String tag = DgUtils.trimQuotes(mResetCfgTag.group(2));
                    new DgCmdConfig(ctx, sqlConn).runEditTag(null, tag, null);
                    return true;
                }
                if (!mResetMemTag.matches()) break;
                String mem = DgUtils.trimQuotes(mResetMemTag.group(2));
                String tag = DgUtils.trimQuotes(mResetMemTag.group(4));
                new DgCmdConfig(ctx, sqlConn).runEditTag(mem, tag, null);
                return true;
            }
            case "CREATE": {
                Matcher m = pnCreateCfg.matcher(sql);
                if (!m.matches()) break;
                String cfgname = DgUtils.trimQuotes(m.group(1));
                String pdbun = DgUtils.trimQuotes(m.group(2));
                String pdgci = DgUtils.trimQuotes(m.group(3));
                boolean incl_dest = m.group(3) != null;
                new DgCmdConfig(ctx, sqlConn).runCreateConfig(cfgname, pdbun, pdgci, incl_dest);
                return true;
            }
            case "FAILOVER": {
                Matcher m = pnFailover.matcher(sql);
                if (!m.matches()) break;
                String dbun = DgUtils.trimQuotes(m.group(1));
                String fo_type = DgUtils.trimQuotes(m.group(2));
                new DgCmdRole(ctx, sqlConn).runFailover(dbun, fo_type);
                return true;
            }
            case "REINSTATE": {
                Matcher m = pnReinsate.matcher(sql);
                if (!m.matches()) break;
                String dbun = DgUtils.trimQuotes(m.group(1));
                new DgCmdRole(ctx, sqlConn).runReinstate(dbun);
                return true;
            }
            case "SWITCHOVER": {
                Matcher m = pnSwitchover.matcher(sql);
                if (!m.matches()) break;
                String dbun = DgUtils.trimQuotes(m.group(1));
                int wait = m.group(2) != null ? 1 : 0;
                int wait_time = -1;
                if (wait > 0 && m.group(3) != null) {
                    wait_time = Integer.valueOf(m.group(3).trim());
                }
                new DgCmdRole(ctx, sqlConn).runSwitchover(dbun, wait, wait_time);
                return true;
            }
            case "SET": {
                this.runSet(ctx, sql);
                return true;
            }
            case "TEST": {
                this.runTest(ctx, sql);
                Properties props = (Properties)ctx.getProperty("cli.conn.props");
                ctx.write("CLI_CONN_PROPS\n");
                ctx.write("ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(): " + ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString() + "\n");
                for (Object key : props.keySet()) {
                    String name = key.toString();
                    ctx.write(String.format("%-20s: %s\n", name, props.getProperty(name)));
                }
                return true;
            }
            default: {
                assert (false);
                break;
            }
        }
        ctx.write(Messages.getString("DGCmd.SYNTAX"));
        return true;
    }

    private void runTest(ScriptRunnerContext ctx, String sql) {
        LOGGER.info("runTest()");
    }

    private void runSet(ScriptRunnerContext ctx, String sql) {
        Matcher m = pnSet.matcher(sql);
        if (m.matches()) {
            String arg1 = DgUtils.trimQuotes(m.group(1));
            String arg2 = DgUtils.trimQuotes(m.group(2));
            if ("DEBUG".equalsIgnoreCase(arg1)) {
                if ("ON".equalsIgnoreCase(arg2)) {
                    ctx.write("DG Debug mode is turned on\n");
                } else {
                    ctx.write("DG Debug mode is turned off\n");
                }
            }
        }
    }
}

