/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.library.Book;

public class TopicTree {
    private final Book _book;
    private final String _basePath;
    private final TopicTreeNode _root;
    private Hashtable _urlTable;

    public TopicTree(Book book, String basePath) {
        this(book, basePath, new TopicTreeNode(null, null));
    }

    public TopicTree(Book book, String basePath, TopicTreeNode root) {
        this._book = book;
        this._basePath = basePath;
        this._root = root;
    }

    public final TopicTreeNode getRoot() {
        return this._root;
    }

    public synchronized Vector findNodesForURL(URL url) {
        Vector nodes = null;
        if (this._urlTable == null) {
            this._urlTable = new Hashtable();
            if (this._root != null) {
                this._buildTableForNode(this._root);
            }
        }
        if (url != null) {
            nodes = (Vector)this._urlTable.get(url.toExternalForm());
        }
        return nodes;
    }

    private void _buildTableForNode(TopicTreeNode node) {
        ArrayList children;
        Target aTarget;
        Topic aTopic = node.getTopic();
        if (aTopic != null && (aTarget = aTopic.getTarget()) != null) {
            URL aURL = null;
            try {
                aURL = aTarget.getURL();
            }
            catch (Exception e) {
                aURL = null;
            }
            if (aURL != null) {
                Vector urlNodes;
                if (this._urlTable.containsKey(aURL.toExternalForm())) {
                    urlNodes = (Vector)this._urlTable.get(aURL.toExternalForm());
                } else {
                    urlNodes = new Vector();
                    this._urlTable.put(aURL.toExternalForm(), urlNodes);
                }
                urlNodes.addElement(node);
            }
        }
        if ((children = node.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                this._buildTableForNode((TopicTreeNode)children.get(i));
            }
        }
    }
}

