/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;

public class IlvBoolEditor
extends PropertyEditorSupport
implements IlvInternationalizedPropertyEditor {
    private ULocale a;
    private String b = "true";
    private String c = "false";

    public IlvBoolEditor() {
        this(IlvLocaleUtil.getCurrentULocale());
    }

    public IlvBoolEditor(ULocale uLocale) {
        this.a = uLocale;
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("editors", IlvBoolEditor.class, uLocale.toLocale());
        this.b = resourceBundle.getString("BoolEditor.True");
        this.c = resourceBundle.getString("BoolEditor.False");
    }

    @Override
    public String getJavaInitializationString() {
        if (((Boolean)this.getValue()).booleanValue()) {
            return "true";
        }
        return "false";
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "false";
        }
        if (((Boolean)object).booleanValue()) {
            return "true";
        }
        return "false";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string == "true") {
            this.setValue(Boolean.TRUE);
            return;
        }
        if (string == "false") {
            this.setValue(Boolean.FALSE);
            return;
        }
        if (string.equalsIgnoreCase("true")) {
            this.setValue(Boolean.TRUE);
        } else if (string.equalsIgnoreCase("false")) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public String[] getTags() {
        String[] stringArray = new String[2];
        stringArray[0] = "true";
        stringArray[1] = "false";
        String[] stringArray2 = stringArray;
        return stringArray2;
    }

    @Override
    public String getAsLocalizedText() {
        if (((Boolean)this.getValue()).booleanValue()) {
            return this.b;
        }
        return this.c;
    }

    @Override
    public void setAsLocalizedText(String string) throws IllegalArgumentException {
        if (string.equalsIgnoreCase(this.b)) {
            this.setValue(Boolean.TRUE);
        } else if (string.equalsIgnoreCase(this.c)) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public String[] getValuesAsLocalizedText() {
        String[] stringArray = new String[]{this.b, this.c};
        return stringArray;
    }
}

