/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkbundle;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvExpandCollapseMarker;
import ilog.views.graphic.IlvSplineLinkImage;
import ilog.views.graphic.composite.IlvCompositeLink;
import ilog.views.graphic.linkbundle.IlvLinkBundle;
import ilog.views.graphic.linkbundle.IlvLinkBundleFrame;
import ilog.views.graphic.linkbundle.IlvLinkBundleLayoutManager;
import ilog.views.graphic.linkbundle.IlvLinkBundleSelection;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;

public class IlvDefaultLinkBundleFrame
implements IlvLinkBundleFrame,
Serializable,
IlvPersistentObject {
    private static final float a = 5.0f;
    private static final Color b = Color.green;
    private static final float c = IlvUtil.GetDeltaLine();
    private float d = 5.0f;
    private Paint e = b;
    private IlvPoint[] f;
    private IlvGraphic g = null;
    private IlvPoint h = new IlvPoint(10.0f, 0.0f);
    private IlvPoint i = new IlvPoint(0.0f, 0.5f);

    public IlvDefaultLinkBundleFrame() {
    }

    public IlvDefaultLinkBundleFrame(IlvDefaultLinkBundleFrame ilvDefaultLinkBundleFrame) {
        this.setMargin(ilvDefaultLinkBundleFrame.getMargin());
        this.setBackground(ilvDefaultLinkBundleFrame.getBackground());
        this.g = ilvDefaultLinkBundleFrame.g != null ? ilvDefaultLinkBundleFrame.g.copy() : null;
        this.i = new IlvPoint(ilvDefaultLinkBundleFrame.i);
        this.h = new IlvPoint(ilvDefaultLinkBundleFrame.h);
    }

    @Override
    public IlvLinkBundleFrame copy() {
        return new IlvDefaultLinkBundleFrame(this);
    }

    public IlvDefaultLinkBundleFrame(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        try {
            this.d = ilvInputStream.readFloat("margin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
        }
        this.e = IlvUtility2D.readPaint(ilvInputStream, "fillColor", "");
        if (this.e == null) {
            this.e = b;
        }
        try {
            this.g = ilvInputStream.readObject("expandCollapseMarker");
            this.h = ilvInputStream.readPoint("absPosition");
            this.i = ilvInputStream.readPoint("relPosition");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.g = null;
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.d != 5.0f) {
            ilvOutputStream.write("margin", this.d);
        }
        IlvUtility2D.writePaint(ilvOutputStream, this.e, "fillColor", "", b);
        if (this.g != null) {
            ilvOutputStream.write("expandCollapseMarker", this.g);
            ilvOutputStream.write("absPosition", this.h);
            ilvOutputStream.write("relPosition", this.i);
        }
    }

    @Override
    public float getMargin(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        return ilvTransformer == null ? this.d : this.d * (float)ilvTransformer.zoomFactor();
    }

    @Override
    public IlvRect boundingBox(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        Rectangle2D rectangle2D = this.a(null, ilvLinkBundle, ilvTransformer, false, null).getBounds2D();
        IlvRect ilvRect = new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        IlvRect ilvRect2 = this.boundingBoxExpandCollapseIcon(ilvLinkBundle, ilvTransformer);
        if (ilvRect2 != null) {
            ilvRect.add(ilvRect2);
        }
        return ilvRect;
    }

    public float getMargin() {
        return this.d;
    }

    public void setMargin(float f) {
        this.d = f;
    }

    public Paint getBackground() {
        return this.e;
    }

    public void setBackground(Paint paint) {
        if (paint == null) {
            paint = b;
        }
        this.e = paint;
    }

    public void setExpandCollapseIcon(IlvGraphic ilvGraphic) {
        this.g = ilvGraphic;
    }

    public IlvGraphic getExpandCollapseIcon() {
        return this.g;
    }

    public boolean isShowingExpandCollapseIcon() {
        return this.g != null;
    }

    public void setShowingExpandCollapseIcon(boolean bl) {
        if (bl != this.isShowingExpandCollapseIcon()) {
            if (bl) {
                this.setExpandCollapseIcon(new IlvExpandCollapseMarker());
            } else {
                this.setExpandCollapseIcon(null);
            }
        }
    }

    public void setExpandCollapseIconPosition(float f, float f2, float f3, float f4) {
        this.h.move(f3, f4);
        this.i.move(f, f2);
    }

    public final IlvPoint getRelativeExpandCollapseIconPosition() {
        return new IlvPoint(this.i);
    }

    public void setRelativeExpandCollapseIconPosition(IlvPoint ilvPoint) {
        this.i = new IlvPoint(ilvPoint);
    }

    public final IlvPoint getAbsoluteExpandCollapseIconPosition() {
        return new IlvPoint(this.h);
    }

    public void setAbsoluteExpandCollapseIconPosition(IlvPoint ilvPoint) {
        this.h = new IlvPoint(ilvPoint);
    }

    @Override
    public void draw(IlvLinkBundle ilvLinkBundle, Graphics graphics, IlvTransformer ilvTransformer) {
        this.a((Graphics2D)graphics, ilvLinkBundle, ilvTransformer, true, this.getBackground());
    }

    @Override
    public void drawSelected(IlvLinkBundle ilvLinkBundle, Graphics graphics, IlvTransformer ilvTransformer, IlvLinkBundleSelection ilvLinkBundleSelection) {
        Paint paint = ilvLinkBundleSelection.getSelectedFramePaint();
        this.a((Graphics2D)graphics, ilvLinkBundle, ilvTransformer, true, paint);
    }

    @Override
    public void drawExpandCollapseIcon(IlvLinkBundle ilvLinkBundle, Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.g != null) {
            IlvPoint ilvPoint = this.getExpandCollapseIconPosition(ilvLinkBundle, ilvTransformer);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
            }
            this.g.move(ilvPoint.x, ilvPoint.y);
            this.g.callDraw(graphics, ilvTransformer);
        }
    }

    @Override
    public IlvRect boundingBoxExpandCollapseIcon(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        if (this.g != null) {
            IlvPoint ilvPoint = this.getExpandCollapseIconPosition(ilvLinkBundle, ilvTransformer);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
            }
            this.g.move(ilvPoint.x, ilvPoint.y);
            return this.g.boundingBox(ilvTransformer);
        }
        return null;
    }

    protected IlvPoint getExpandCollapseIconPosition(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        if (this.g == null) {
            return null;
        }
        if (this.g instanceof IlvExpandCollapseMarker) {
            ((IlvExpandCollapseMarker)this.g).setExpandedIcon(!ilvLinkBundle.isCollapsed());
        }
        double d4 = this.i.x;
        double d5 = this.i.y;
        double d6 = this.h.x;
        double d7 = this.h.y;
        if (ilvTransformer != null) {
            d6 *= ilvTransformer.zoomFactor();
            d7 *= ilvTransformer.zoomFactor();
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (ilvLinkBundle.isCollapsed()) {
            d5 = 0.5;
            d7 = 0.0;
        }
        float f = ilvLinkBundle.getLineWidth(ilvTransformer);
        IlvPoint[] ilvPointArray = ilvLinkBundle.getLinkPoints(ilvTransformer);
        double d8 = 0.0;
        for (int i = 1; i < ilvPointArray.length; ++i) {
            d3 = ilvPointArray[i].x - ilvPointArray[i - 1].x;
            d2 = ilvPointArray[i].y - ilvPointArray[i - 1].y;
            d = Math.sqrt(d3 * d3 + d2 * d2);
            d8 += d;
        }
        double d9 = Math.min(d4 * d8, d8);
        double d10 = ilvPointArray[0].x;
        double d11 = ilvPointArray[0].y;
        d8 = 0.0;
        for (int i = 1; i < ilvPointArray.length; ++i) {
            d3 = ilvPointArray[i].x - ilvPointArray[i - 1].x;
            d2 = ilvPointArray[i].y - ilvPointArray[i - 1].y;
            d = Math.sqrt(d3 * d3 + d2 * d2);
            if (d == 0.0) continue;
            if (d + d8 >= d9 || i == ilvPointArray.length - 1) {
                double d12 = d9 - d8;
                d10 = (double)ilvPointArray[i - 1].x + d12 * d3 / d;
                d11 = (double)ilvPointArray[i - 1].y + d12 * d2 / d;
                d10 -= (double)f * (d5 - 0.5) * d2 / d;
                d11 += (double)f * (d5 - 0.5) * d3 / d;
                d10 += d6 * d3 / d;
                d11 += d6 * d2 / d;
                d10 -= d7 * d2 / d;
                d11 += d7 * d3 / d;
                break;
            }
            d8 += d;
        }
        IlvRect ilvRect = this.g.boundingBox(ilvTransformer);
        return new IlvPoint((float)d10 - 0.5f * ilvRect.width, (float)d11 - 0.5f * ilvRect.height);
    }

    private Shape a(Graphics2D graphics2D, IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer, boolean bl, Paint paint) {
        IlvLinkImage ilvLinkImage;
        int n;
        int n2 = ilvLinkBundle.getSublinksCount();
        GeneralPath generalPath = new GeneralPath();
        IlvGraphic ilvGraphic = ilvLinkBundle.getVisibleFrom();
        IlvGraphic ilvGraphic2 = ilvLinkBundle.getVisibleTo();
        IlvLinkImage ilvLinkImage2 = null;
        IlvLinkBundle ilvLinkBundle2 = null;
        if (n2 > 0) {
            ilvLinkImage2 = ilvLinkBundle.getSublink(0);
            ilvLinkBundle2 = n2 > 1 ? ilvLinkBundle.getSublink(n2 - 1) : ilvLinkImage2;
        } else {
            ilvLinkBundle2 = ilvLinkImage2 = ilvLinkBundle;
        }
        IlvLinkBundleLayoutManager ilvLinkBundleLayoutManager = ilvLinkBundle.a();
        IlvPolyPointsInterface ilvPolyPointsInterface = ilvLinkBundleLayoutManager.getMargin(ilvLinkBundle, true, ilvTransformer);
        IlvPolyPointsInterface ilvPolyPointsInterface2 = ilvLinkBundleLayoutManager.getMargin(ilvLinkBundle, false, ilvTransformer);
        IlvPoint ilvPoint = this.a(ilvLinkImage2, ilvGraphic, true, ilvTransformer);
        generalPath.moveTo(ilvPoint.x, ilvPoint.y);
        for (n = 1; n < n2; ++n) {
            ilvLinkImage = ilvLinkBundle.getSublink(n);
            ilvPoint = this.a(ilvLinkImage, ilvGraphic, true, ilvTransformer);
            generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        }
        n = 0;
        IlvPoint[] ilvPointArray = this.a(ilvPolyPointsInterface2, null, n != 0);
        float f = this.a((IlvLinkImage)ilvLinkBundle2, false);
        boolean bl2 = f > -3.4028235E38f;
        Shape shape = bl2 ? this.a(ilvPointArray, f, n != 0) : this.a(ilvPointArray, n != 0);
        generalPath.append(shape, true);
        ilvPoint = this.a(ilvLinkBundle2, ilvGraphic2, false, ilvTransformer);
        generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        for (int i = n2 - 2; i >= 0; --i) {
            ilvLinkImage = ilvLinkBundle.getSublink(i);
            ilvPoint = this.a(ilvLinkImage, ilvGraphic2, false, ilvTransformer);
            generalPath.lineTo(ilvPoint.x, ilvPoint.y);
        }
        n = 1;
        ilvPointArray = this.a(ilvPolyPointsInterface, null, n != 0);
        f = this.a(ilvLinkImage2, true);
        bl2 = f > -3.4028235E38f;
        Shape shape2 = bl2 ? this.a(ilvPointArray, f, n != 0) : this.a(ilvPointArray, n != 0);
        generalPath.append(shape2, true);
        generalPath.closePath();
        if (bl) {
            Paint paint2 = paint;
            if (!(paint2 instanceof Color)) {
                graphics2D.setPaint(IlvUtility2D.AdaptPaint(generalPath, paint2));
            } else {
                graphics2D.setPaint(paint2);
            }
            graphics2D.fill(generalPath);
        }
        return generalPath;
    }

    private float a(IlvLinkImage ilvLinkImage, boolean bl) {
        if (ilvLinkImage instanceof IlvSplineLinkImage) {
            return ((IlvSplineLinkImage)ilvLinkImage).getSmoothness();
        }
        if (ilvLinkImage instanceof IlvCompositeLink) {
            IlvCompositeLink ilvCompositeLink = (IlvCompositeLink)ilvLinkImage;
            return this.a(ilvCompositeLink.getLink(), bl);
        }
        if (ilvLinkImage instanceof IlvLinkBundle) {
            IlvLinkBundle ilvLinkBundle = (IlvLinkBundle)ilvLinkImage;
            if (ilvLinkBundle.isCollapsed()) {
                return this.a(ilvLinkBundle.getOverviewLink(), bl);
            }
            int n = ilvLinkBundle.getSublinksCount();
            if (n == 0) {
                return -3.4028235E38f;
            }
            return this.a(ilvLinkBundle.getSublink(bl ? 0 : n - 1), bl);
        }
        return -3.4028235E38f;
    }

    IlvPoint a(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, boolean bl, IlvTransformer ilvTransformer) {
        if (ilvLinkImage.getVisibleFrom() == ilvLinkImage.getVisibleTo()) {
            if (bl) {
                return ilvLinkImage.getPointAt(0, ilvTransformer);
            }
            return ilvLinkImage.getPointAt(ilvLinkImage.getPointsCardinal() - 1, ilvTransformer);
        }
        if (this.a(ilvLinkImage.getVisibleFrom(), ilvGraphic)) {
            return ilvLinkImage.getPointAt(0, ilvTransformer);
        }
        if (this.a(ilvLinkImage.getVisibleTo(), ilvGraphic)) {
            return ilvLinkImage.getPointAt(ilvLinkImage.getPointsCardinal() - 1, ilvTransformer);
        }
        throw new RuntimeException("Node " + ilvGraphic + " is not the origin, nor the destination of " + ilvLinkImage);
    }

    private boolean a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        return IlvLinkBundleLayoutManager.a(ilvGraphic, ilvGraphic2);
    }

    private Shape a(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        IlvLinkBundle ilvLinkBundle2 = ilvLinkBundle.isCollapsed() ? (ilvLinkBundle.getOverviewLink() != null ? ilvLinkBundle.getOverviewLink() : ilvLinkBundle) : ilvLinkBundle;
        return this.a((IlvLinkImage)ilvLinkBundle2, ilvTransformer);
    }

    private Shape a(IlvSplineLinkImage ilvSplineLinkImage, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        boolean bl = !this.a(ilvSplineLinkImage.getVisibleFrom(), ilvGraphic);
        IlvPoint[] ilvPointArray = ilvSplineLinkImage.getLinkPoints(ilvTransformer);
        return this.a(ilvPointArray, ilvSplineLinkImage.getSmoothness(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape a(IlvPoint[] ilvPointArray, float f, boolean bl) {
        int n = ilvPointArray.length;
        GeneralPath generalPath = new GeneralPath();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            IlvPoint ilvPoint;
            IlvPoint ilvPoint2;
            if (n > 2) {
                if (f != -1.0f) {
                    this.f = IlvGraphicUtil.GetSmoothSpline(ilvPointArray, n, f, false, this.f);
                    n = (n - 2) * 3 + 1;
                    ilvPointArray = this.f;
                }
            }
            int n2 = 3 * ((n - 1) / 3);
            IlvPoint ilvPoint3 = this.a(ilvPointArray, 0, bl);
            generalPath.moveTo(ilvPoint3.x, ilvPoint3.y);
            int n3 = 1;
            while (n3 < n2) {
                ilvPoint2 = this.a(ilvPointArray, n3++, bl);
                ilvPoint = this.a(ilvPointArray, n3++, bl);
                IlvPoint ilvPoint4 = this.a(ilvPointArray, n3++, bl);
                generalPath.curveTo(ilvPoint2.x, ilvPoint2.y, ilvPoint.x, ilvPoint.y, ilvPoint4.x, ilvPoint4.y);
            }
            if (n - ++n2 == 2) {
                ilvPoint2 = this.a(ilvPointArray, n2, bl);
                ilvPoint = this.a(ilvPointArray, n2 + 1, bl);
                generalPath.curveTo(ilvPoint2.x, ilvPoint2.y, ilvPoint2.x, ilvPoint2.y, ilvPoint.x, ilvPoint.y);
            } else if (n - n2 == 1) {
                ilvPoint3 = this.a(ilvPointArray, n2, bl);
                generalPath.lineTo(ilvPoint3.x, ilvPoint3.y);
            }
        }
        return generalPath;
    }

    private IlvPoint a(IlvPoint[] ilvPointArray, int n, boolean bl) {
        if (bl) {
            n = ilvPointArray.length - n - 1;
        }
        return ilvPointArray[n];
    }

    private Shape a(IlvLinkImage ilvLinkImage, IlvTransformer ilvTransformer) {
        return this.a(ilvLinkImage, ilvLinkImage.getVisibleFrom(), ilvTransformer);
    }

    private Shape a(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvLinkImage instanceof IlvSplineLinkImage) {
            return this.a((IlvSplineLinkImage)ilvLinkImage, ilvGraphic, ilvTransformer);
        }
        if (ilvLinkImage instanceof IlvLinkBundle) {
            return this.a((IlvLinkBundle)ilvLinkImage, ilvTransformer);
        }
        boolean bl = !this.a(ilvLinkImage.getVisibleFrom(), ilvGraphic);
        return this.b(ilvLinkImage, ilvTransformer, bl);
    }

    private IlvPoint[] a(IlvPolyPointsInterface ilvPolyPointsInterface, IlvTransformer ilvTransformer, boolean bl) {
        int n = ilvPolyPointsInterface.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                ilvPointArray[i] = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
            }
        }
        return ilvPointArray;
    }

    private Shape b(IlvPolyPointsInterface ilvPolyPointsInterface, IlvTransformer ilvTransformer, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        int n = ilvPolyPointsInterface.getPointsCardinal();
        if (bl) {
            IlvPoint ilvPoint = ilvPolyPointsInterface.getPointAt(n - 1, ilvTransformer);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            for (int i = n - 2; i >= 0; --i) {
                ilvPoint = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
                generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            }
        } else {
            IlvPoint ilvPoint = ilvPolyPointsInterface.getPointAt(0, ilvTransformer);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            for (int i = 1; i < n; ++i) {
                ilvPoint = ilvPolyPointsInterface.getPointAt(i, ilvTransformer);
                generalPath.lineTo(ilvPoint.x, ilvPoint.y);
            }
        }
        return generalPath;
    }

    private Shape a(IlvPoint[] ilvPointArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        int n = ilvPointArray.length;
        if (bl) {
            generalPath.moveTo(ilvPointArray[n - 1].x, ilvPointArray[n - 1].y);
            for (int i = n - 2; i >= 0; --i) {
                generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        } else {
            generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        }
        return generalPath;
    }

    @Override
    public boolean contains(IlvLinkBundle ilvLinkBundle, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvLinkBundle.boundingBox(ilvTransformer);
        float f = this.getMargin() + c;
        ilvRect.expand(f);
        if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        IlvRect ilvRect2 = this.boundingBoxExpandCollapseIcon(ilvLinkBundle, ilvTransformer);
        if (ilvRect2 != null && ilvRect2.contains(ilvPoint2)) {
            return true;
        }
        Shape shape = this.a(null, ilvLinkBundle, ilvTransformer, false, null);
        return shape.contains(ilvPoint2.x, ilvPoint2.y);
    }
}

