/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import liquibase.exception.DatabaseException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OraclePreparedStatement;

public class DbmsMetaUtils {
    public static String getAlterDdl(Connection conn, String source, String dest, String type) throws SQLException {
        return DbmsMetaUtils.getAlterDdl(conn, source, dest, type, LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAlterDdlWithTransform(Connection conn, String source, String dest, String type, String oname, boolean cons, boolean consasalter, boolean refcons, boolean storage, boolean segs, boolean tblspc, boolean emit, String schema, String coll) throws SQLException {
        String s = source;
        String d = dest;
        String query = QueryUtils.getXMLQueries().getQuery("alterDdlwithTransforms", conn).getSql();
        Clob holder = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        if ("TABLE".equalsIgnoreCase(type) || "SEQUENCE".equalsIgnoreCase(type)) {
            if (source != null && !source.isEmpty()) {
                s = source.replaceAll("<START_WITH>[0-9]*</START_WITH>", "<START_WITH>1</START_WITH>");
            }
            if (dest != null && !dest.isEmpty()) {
                d = dest.replaceAll("<START_WITH>[0-9]*</START_WITH>", "<START_WITH>1</START_WITH>");
            }
        }
        try {
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, s);
            pstatement.setStringForClob(2, d);
            pstatement.setString(3, type.toUpperCase());
            pstatement.setString(4, oname.toUpperCase());
            pstatement.setInt(5, cons ? 0 : 1);
            pstatement.setInt(6, consasalter ? 0 : 1);
            pstatement.setInt(7, refcons ? 0 : 1);
            pstatement.setInt(8, storage ? 0 : 1);
            pstatement.setInt(9, segs ? 0 : 1);
            pstatement.setInt(10, tblspc ? 0 : 1);
            pstatement.setInt(11, emit ? 0 : 1);
            pstatement.setString(12, schema.toUpperCase());
            pstatement.setString(13, coll.toUpperCase());
            rs = pstatement.executeQuery();
            while (null != rs && rs.next()) {
                holder = rs.getClob(1);
            }
            String ddl = null == holder || 0L == holder.length() ? null : holder.getSubString(1L, (int)holder.length());
            String string = ddl;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAlterDdl(Connection conn, String source, String dest, String type, boolean debug) throws SQLException {
        String s = source;
        String d = dest;
        String query = QueryUtils.getXMLQueries().getQuery("alterDdl", conn).getSql();
        Clob v_return = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            if ("TABLE".equalsIgnoreCase(type) || "SEQUENCE".equalsIgnoreCase(type)) {
                if (source != null && !source.isEmpty()) {
                    s = source.replaceAll("<START_WITH>[0-9]*</START_WITH>", "<START_WITH>1</START_WITH>");
                }
                if (dest != null && !dest.isEmpty()) {
                    d = dest.replaceAll("<START_WITH>[0-9]*</START_WITH>", "<START_WITH>1</START_WITH>");
                }
            }
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            if (debug) {
                Logger.info(DbmsMetaUtils.class, (String)"##################################################################################");
                Logger.info(DbmsMetaUtils.class, (String)"doc 1 - source");
                Logger.info(DbmsMetaUtils.class, (String)s);
                Logger.info(DbmsMetaUtils.class, (String)"##################################################################################");
                Logger.info(DbmsMetaUtils.class, (String)"doc 2 - dest");
                Logger.info(DbmsMetaUtils.class, (String)d);
                Logger.info(DbmsMetaUtils.class, (String)"##################################################################################");
            }
            pstatement.setStringForClob(1, s);
            pstatement.setStringForClob(2, d);
            pstatement.setString(3, type);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                String string = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (null != pstatement) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (null != rs && rs.next()) {
                v_return = rs.getClob(1);
            }
            if (0L < (null != v_return ? v_return.length() : 0L)) {
                String string = v_return.getSubString(1L, (int)v_return.length());
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDdlFromSxml(Connection conn, String sxml, String oType) throws SQLException {
        String query = QueryUtils.getXMLQueries().getQuery("sxmlToDdlConvertFunction", conn).getSql();
        Clob holder = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> parms = DbmsMetaUtils.getDDLParms(conn);
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, sxml.trim());
            pstatement.setString(2, oType);
            pstatement.setInt(3, "ON".equals(parms.get("CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(4, "ON".equals(parms.get("REF_CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(5, "ON".equals(parms.get("OID")) ? 0 : 1);
            pstatement.setInt(6, "ON".equals(parms.get("STORAGE")) ? 0 : 1);
            pstatement.setInt(7, "ON".equals(parms.get("SEGMENT_ATTRIBUTES")) ? 0 : 1);
            pstatement.setInt(8, "ON".equals(parms.get("TABLESPACE")) ? 0 : 1);
            pstatement.setInt(9, "ON".equals(parms.get("PARTITIONING")) ? 0 : 1);
            String COLLATION = (String)parms.get("COLLATION_CLAUSE");
            pstatement.setString(10, null == COLLATION ? "NEVER" : COLLATION);
            pstatement.setString(11, conn.getSchema());
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                Logger.warn(DbmsMetaUtils.class, (Throwable)e);
                throw e;
            }
            while (null != rs && rs.next()) {
                holder = rs.getClob(1);
            }
            String ddl = null == holder || 0L == holder.length() ? null : holder.getSubString(1L, (int)holder.length());
            String string = ddl;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDdlFromXml(Connection conn, String xml, String oType) throws SQLException {
        String query = QueryUtils.getXMLQueries().getQuery("xmlToDdlConvertFunction", conn).getSql();
        Clob holder = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> parms = DbmsMetaUtils.getDDLParms(conn);
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, xml.trim());
            pstatement.setString(2, oType);
            pstatement.setInt(3, "ON".equals(parms.get("CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(4, "ON".equals(parms.get("REF_CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(5, "ON".equals(parms.get("OID")) ? 0 : 1);
            pstatement.setInt(6, "ON".equals(parms.get("STORAGE")) ? 0 : 1);
            pstatement.setInt(7, "ON".equals(parms.get("SEGMENT_ATTRIBUTES")) ? 0 : 1);
            pstatement.setInt(8, "ON".equals(parms.get("TABLESPACE")) ? 0 : 1);
            pstatement.setInt(9, "ON".equals(parms.get("PARTITIONING")) ? 0 : 1);
            String COLLATION = (String)parms.get("COLLATION_CLAUSE");
            pstatement.setString(10, null == COLLATION ? "NEVER" : COLLATION);
            pstatement.setString(11, conn.getSchema());
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                Logger.warn(DbmsMetaUtils.class, (Throwable)e);
                throw e;
            }
            while (null != rs && rs.next()) {
                holder = rs.getClob(1);
            }
            String ddl = null == holder || 0L == holder.length() ? null : holder.getSubString(1L, (int)holder.length());
            String string = ddl;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static HashMap<String, Object> getDDLParms(Connection conn) {
        ScriptRunnerContext ctx = LbUtils.getContext();
        if (null == ctx) {
            throw new RuntimeException("Unable to determine context, can not proceeed.");
        }
        ScriptRunnerContext.Parameters instance = ctx.getParameterInstance();
        if (null == instance) {
            throw new RuntimeException("Unable to determine context, can not proceeed.");
        }
        HashMap parms = instance.getParameters("ddl.parms");
        if (null == parms || parms.isEmpty()) {
            ctx.setCurrentConnection(conn);
            SetDDLSettings.resetDDLParameters((ScriptRunnerContext)ctx);
            parms = instance.getParameters("ddl.parms");
        }
        return parms;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getObjectFromDb(Connection conn, String otype, String oname) throws DatabaseException {
        String oType = otype.toUpperCase();
        String oName = oname.toUpperCase();
        if ("SCRIPT".equalsIgnoreCase(oType)) {
            return null;
        }
        if ("COMMENT".equalsIgnoreCase(oType)) {
            DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
            return dbUtil.executeReturnOneCol("select dbms_metadata.get_dependent_ddl( 'COMMENT', '" + oname + "') from dual");
        }
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            String string;
            String query;
            ScriptRunnerContext.Parameters parms;
            if (SchemaGenerator.ddlTypes.contains(oType)) {
                parms = DbmsMetaUtils.getDDLParms(conn);
                query = QueryUtils.getXMLQueries().getQuery("getDDL", conn).getSql();
                pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
                pstatement.setString(1, oType);
                pstatement.setString(2, oName);
                pstatement.setString(3, (String)parms.get("STORAGE"));
                pstatement.setString(4, (String)parms.get("TABLESPACE"));
                pstatement.setString(5, (String)parms.get("SEGMENT_ATTRIBUTES"));
                pstatement.setString(6, (String)parms.get("CONSTRAINTS"));
                pstatement.setString(7, (String)parms.get("PARTITIONING"));
                String COLLATION = (String)parms.get("COLLATION_CLAUSE");
                pstatement.setString(8, null == COLLATION ? "NEVER" : COLLATION);
            } else {
                query = QueryUtils.getXMLQueries().getQuery("getSXML", conn).getSql();
                pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
                parms = LbUtils.getContext().getParameterInstance();
                if (parms == null) {
                    String string2 = null;
                    return string2;
                }
                pstatement.setString(1, oType);
                pstatement.setString(2, oName);
                pstatement.setString(3, (String)parms.getParameters("ddl.parms").get("STORAGE"));
                pstatement.setString(4, (String)parms.getParameters("ddl.parms").get("TABLESPACE"));
                pstatement.setString(5, (String)parms.getParameters("ddl.parms").get("SEGMENT_ATTRIBUTES"));
                pstatement.setString(6, (String)parms.getParameters("ddl.parms").get("CONSTRAINTS"));
                pstatement.setString(7, (String)parms.getParameters("ddl.parms").get("PARTITIONING"));
                pstatement.setString(8, (String)parms.getParameters("ddl.parms").get("REF_CONSTRAINTS"));
            }
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                string = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (null == pstatement) return string;
                try {
                    pstatement.close();
                    return string;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return string;
            }
            Clob clob = null;
            while (null != rs && rs.next()) {
                clob = rs.getClob(1);
            }
            if (null != clob) {
                string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            string = null;
            return string;
        }
        catch (Exception e) {
            Logger.warn(DbmsMetaUtils.class, (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getDDLFromDb(Connection conn, String otype, String oname) throws DatabaseException {
        String oType = otype.toUpperCase();
        String oName = oname.toUpperCase();
        if ("SCRIPT".equalsIgnoreCase(oType)) {
            return null;
        }
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> parms = DbmsMetaUtils.getDDLParms(conn);
            String query = QueryUtils.getXMLQueries().getQuery("getDDL", conn).getSql();
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setString(1, oType);
            pstatement.setString(2, oName);
            pstatement.setString(3, (String)parms.get("STORAGE"));
            pstatement.setString(4, (String)parms.get("TABLESPACE"));
            pstatement.setString(5, (String)parms.get("SEGMENT_ATTRIBUTES"));
            pstatement.setString(6, (String)parms.get("CONSTRAINTS"));
            pstatement.setString(7, (String)parms.get("PARTITIONING"));
            String COLLATION = (String)parms.get("COLLATION_CLAUSE");
            pstatement.setString(8, null == COLLATION ? "NEVER" : COLLATION);
            rs = pstatement.executeQuery();
            Clob clob = null;
            while (null != rs && rs.next()) {
                clob = rs.getClob(1);
            }
            if (null != clob) {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        catch (Exception e) {
            Logger.warn(DbmsMetaUtils.class, (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != pstatement) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static boolean isSxmlType(String name) {
        try {
            SXML_OBJECT_TYPES.valueOf(name.toUpperCase().trim());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum SXML_OBJECT_TYPES {
        AQ_QUEUE,
        AQ_QUEUE_TABLE,
        AQ_TRANSFORM,
        ASSOCIATION,
        AUDIT,
        AUDIT_OBJ,
        CLUSTER,
        CONTEXT,
        DEFAULT_ROLE,
        DATABASE_EXPORT,
        FGA_POLICY,
        DIMENSION,
        INDEX,
        LIBRARY,
        INDEXTYPE,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PROFILE,
        PROXY,
        REFRESH_GROUP,
        RESOURCE_COST,
        RLS_CONTEXT,
        RLS_GROUP,
        RLS_POLICY,
        RMGR_CONSUMER_GROUP,
        RMGR_INTITIAL_CONSUMER_GROUP,
        RMGR_PLAN,
        RMGR_PLAN_DIRECTIVE,
        ROLE,
        ROLLBACK_SEGMENT,
        SEQUENCE,
        TABLE,
        TABLESPACE,
        TRUSTED_DB_LINK,
        TYPE,
        USER,
        VIEW,
        XMLSCHEMA,
        XS_ACL,
        XS_ACL_PARAM,
        XS_DATA_SECURITY,
        XS_NAMESPACE,
        XS_ROLE,
        XS_ROLESET,
        XS_ROLE_GRANT,
        XS_SECURITY_CLASS,
        XS_USER;

    }
}

