/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.nio.file.Paths;
import java.util.Objects;
import liquibase.change.AbstractChange;
import liquibase.changelog.ChangeSet;

public abstract class AbstractOracleChange
extends AbstractChange {
    private Boolean replaceIfExists = false;
    private String sourceType = null;
    private String objectName = null;
    private String objectType = null;
    private String ownerName = null;
    private String source = null;
    private String id = null;
    private String author = null;
    private String file = null;
    private String relativeToChangelogFile = null;

    public AbstractOracleChange() {
    }

    public AbstractOracleChange(AbstractOracleChange change) {
        this.id = change.getId();
        this.author = change.getAuthor();
        if (change.getFile() != null) {
            this.file = Paths.get(change.getFile(), new String[0]).normalize().toString();
        }
        this.replaceIfExists = change.getReplaceIfExists();
        this.sourceType = change.getSourceType();
        this.objectName = change.getObjectName();
        this.objectType = change.getObjectType();
        this.ownerName = change.getOwnerName();
        this.source = change.getSource();
        this.relativeToChangelogFile = change.getRelativeToChangelogFile();
        super.setChangeSet(change.getChangeSet());
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = Paths.get(file, new String[0]).normalize().toString();
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(String replace) {
        this.replaceIfExists = Boolean.parseBoolean(replace);
    }

    public void setReplaceIfExists(Boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getSource() {
        return this.source;
    }

    public String getRelativeToChangelogFile() {
        return Objects.requireNonNullElse(this.relativeToChangelogFile, "false");
    }

    public void setRelativeToChangelogFile(String relativeToChangelog) {
        this.relativeToChangelogFile = relativeToChangelog;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChangeSet(ChangeSet changeSet) {
        if (changeSet.getFilePath() != null) {
            changeSet.setFilePath(Paths.get(changeSet.getFilePath(), new String[0]).normalize().toString());
        }
        super.setChangeSet(changeSet);
    }
}

