/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.executors;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.DataPumpQuery;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.transfer.location.OracleDbDirectoryLocation;
import oracle.jdbc.OracleCallableStatement;

public class DataPumpExecutor {
    private DataPumpModel _model;

    public DataPumpExecutor(DataPumpModel model) {
        this._model = model;
    }

    public boolean execSql() {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_EXEC"));
        }
        try {
            this.doDebug(DataPumpResources.format("DPEXEC_GENSQL", this._model.getGenSql()));
            Map<String, String> genBinds = this._model.getGenBinds();
            Set<String> keys = genBinds.keySet();
            for (String key : keys) {
                this.doDebug(DataPumpResources.format("DPEXEC_BINDS", key, genBinds.get(key)));
            }
            ArrayList<String> outBinds = new ArrayList<String>();
            outBinds.add("jobnameout");
            outBinds.add("errorlogout");
            Map<String, String> outputBinds = this.prepared(this._model.getGenSql(), this._model.getGenBinds(), outBinds);
            keys = outputBinds.keySet();
            for (String key : keys) {
                if (key.equals("errorlogout") && outputBinds.get(key) != null) {
                    String beforeReplace = outputBinds.get(key);
                    String afterReplace = beforeReplace.replace(":DPEXEC_DATAPUMP_OPERATION_STATUS:", DataPumpResources.get("DPEXEC_DATAPUMP_OPERATION_STATUS")).replace(":DPEXEC_SUCCESS_WITH_INFO:", DataPumpResources.get("DPEXEC_SUCCESS_WITH_INFO"));
                    outputBinds.put(key, afterReplace);
                }
                if (key.equals("jobnameout")) {
                    if (outputBinds.get(key) == null) continue;
                    this._model.getToolLogger().log("Jobname = " + outputBinds.get(key));
                    continue;
                }
                if (key.equals("errorlogout") && outputBinds.get(key) != null) {
                    this._model.getToolLogger().log(outputBinds.get(key));
                    continue;
                }
                if (key.equals("errorlogout") && outputBinds.get(key) == null) continue;
                this.doDebugDisplay(DataPumpResources.format("DPEXEC_OUTPUT_BINDS", key, outputBinds.get(key)));
            }
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logProcessEnd();
            }
        }
        catch (Exception e) {
            this.doDebugDisplay(e.getLocalizedMessage());
        }
        if (!this._model.ToolLoggerFlushLog()) {
            this._model.isValid(false);
        }
        return this._model.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> prepared(String plsqlBlock, Map<String, String> inBinds, ArrayList<String> outBinds) {
        HashMap<String, String> output;
        block134: {
            Connection conn = this._model.getConn();
            output = new HashMap<String, String>();
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return output;
            }
            boolean amILocked = false;
            OracleCallableStatement prepare = null;
            try {
                Object nl;
                int i;
                amILocked = LockManager.lock((Connection)conn);
                if (!amILocked) break block134;
                String log = inBinds.get("FILENAME_LOG");
                String logDir = inBinds.get("DIRECTORY_LOG");
                prepare = (OracleCallableStatement)conn.prepareCall(plsqlBlock);
                ArrayList binds = Parser.getInstance().getBinds(plsqlBlock, true);
                this.doDebug(DataPumpResources.format("DPEXEC_BINDS_PARSED", binds.size(), inBinds.size(), outBinds.size()));
                for (i = 0; i < binds.size(); ++i) {
                    this.doDebug(DataPumpResources.format("DPEXEC_BINDS_PARSED_INDIVIDUAL", ((Bind)binds.get(i)).getName()));
                    if (inBinds.get(((Bind)binds.get(i)).getName()) != null || outBinds.contains(((Bind)binds.get(i)).getName())) continue;
                    this.doDebug(DataPumpResources.format("DPEXEC_BINDS_PARSED_NOT_SET", ((Bind)binds.get(i)).getName()));
                }
                block102: for (i = 0; i < binds.size(); ++i) {
                    for (String key : inBinds.keySet()) {
                        if (!key.equals(((Bind)binds.get(i)).getName())) continue;
                        prepare.setString(i + 1, inBinds.get(key));
                        this.doDebug(DataPumpResources.format("DPEXEC_BINDS_BIND_SET", i + 1, key));
                        continue block102;
                    }
                }
                block104: for (i = 0; i < binds.size(); ++i) {
                    for (String outputBind : outBinds) {
                        if (!outputBind.equals(((Bind)binds.get(i)).getName())) continue;
                        prepare.registerOutParameter(i + 1, 12);
                        this.doDebug(DataPumpResources.format("DPEXEC_BINDS_OUTPUT_BIND_SET", i + 1, outputBind));
                        continue block104;
                    }
                }
                String jobName = (String)this._model.getArgs().get("jobname");
                this._model.getToolLogger().log(DataPumpResources.get("DPEXEC_INITIATING"));
                String timeZoneVersion = this.getTimeZoneVersion();
                if (timeZoneVersion != null) {
                    this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_TIMEZONE_FILE_VERSION", timeZoneVersion));
                }
                if (this._model.isArgTrue("verbose") || !this._model.isArgTrue("wait")) {
                    this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_CHECK_STATUS", MessageFormat.format(DataPumpQuery.getQuery("datapumpStatus", this._model.getConn()).trim() + System.lineSeparator(), jobName)));
                    this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_LAST_LINE", MessageFormat.format(DataPumpQuery.getQuery("datapumpLastLine", this._model.getConn()).trim() + ";" + System.lineSeparator(), jobName, jobName)));
                }
                this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_LOG_LOCATION", logDir + ":" + log));
                if (this._model.isArgTrue("verbose")) {
                    nl = System.getProperty("line.separator");
                    this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_GET_PERCENT", MessageFormat.format(DataPumpQuery.getQuery("datapumpPercentComplete", this._model.getConn()).trim().replace("\r\n", "\n").replace("\n", (CharSequence)nl) + (String)nl, jobName)));
                }
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                    nl = output;
                    return nl;
                }
                prepare.executeUpdate();
                block106: for (int i2 = 0; i2 < binds.size(); ++i2) {
                    for (String outputBind : outBinds) {
                        if (!outputBind.equals(((Bind)binds.get(i2)).getName())) continue;
                        output.put(outputBind, prepare.getString(i2 + 1));
                        continue block106;
                    }
                }
                this.doDebug(DataPumpResources.format("DPEXEC_WAIT", (String)this._model.getArgs().get("wait")));
                String completedJobName = (String)output.get("jobnameout");
                boolean genWait = false;
                if (this._model.isArgTrue("wait")) {
                    genWait = true;
                }
                boolean failed = true;
                if (genWait && log != null && logDir != null) {
                    OracleDbDirectoryLocation db = new OracleDbDirectoryLocation(conn);
                    Statement p = null;
                    ResultSet rs = null;
                    BufferedReader br = null;
                    InputStream is = null;
                    Clob cin = null;
                    Clob c = null;
                    Blob b = null;
                    FilterOutputStream o = null;
                    OracleCallableStatement stmt = null;
                    try {
                        String line;
                        int i3;
                        String call = DataPumpQuery.getQuery("datapumpBlobToClob", conn);
                        stmt = (OracleCallableStatement)conn.prepareCall(call);
                        stmt.registerOutParameter(1, 2005);
                        stmt.registerOutParameter(3, 4);
                        is = db.asInputStream(Paths.get(logDir + "/" + log, new String[0]), 0L, 0L);
                        b = conn.createBlob();
                        cin = conn.createClob();
                        o = new BufferedOutputStream(b.setBinaryStream(1L));
                        BufferedInputStream bis = new BufferedInputStream(is);
                        int bufSize = 100;
                        byte[] theBuff = new byte[bufSize];
                        while ((i3 = bis.read(theBuff)) != -1) {
                            ((BufferedOutputStream)o).write(theBuff, 0, i3);
                        }
                        ((BufferedOutputStream)o).flush();
                        stmt.setClob(1, cin);
                        stmt.setBlob(2, b);
                        stmt.execute();
                        c = stmt.getClob(1);
                        int back = stmt.getInt(3);
                        if (back != 0) {
                            throw new SQLException(DataPumpResources.get("DPEXEC_LOB_ERROR"));
                        }
                        br = new BufferedReader(c.getCharacterStream());
                        StringBuilder soFar = new StringBuilder("");
                        while ((line = br.readLine()) != null) {
                            soFar.append(line).append(System.lineSeparator());
                        }
                        this._model.getToolLogger().log(soFar.toString());
                        failed = false;
                    }
                    catch (IOException e) {
                        this.doDebug(e.getMessage());
                    }
                    catch (SQLException e) {
                        this.doDebug(e.getMessage());
                    }
                    finally {
                        try {
                            if (o != null) {
                                o.close();
                            }
                        }
                        catch (IOException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (b != null) {
                                b.free();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (c != null) {
                                c.free();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (cin != null) {
                                cin.free();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (br != null) {
                                br.close();
                            }
                        }
                        catch (IOException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (p != null) {
                                p.close();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e) {
                            this.doDebug(e.getMessage());
                        }
                        try {
                            if (db != null) {
                                db.close();
                            }
                        }
                        catch (IOException e) {
                            this.doDebug(e.getMessage());
                        }
                    }
                }
                if (failed && genWait && completedJobName != null && !completedJobName.equals("")) {
                    DBUtil current = DBUtil.getInstance((Connection)conn);
                    current.getLastException();
                    HashMap<String, String> assertbinds = new HashMap<String, String>();
                    assertbinds.put("NAME", completedJobName);
                    current.executeReturnOneCol(DataPumpQuery.getQuery("datapumpAssertObjectName", conn), assertbinds);
                    SQLException se = current.getLastException();
                    if (se != null) {
                        this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_MASTER_TABLE", completedJobName));
                    } else {
                        String displayCompleted = current.executeReturnOneCol(MessageFormat.format(DataPumpQuery.getQuery("datapumpLastLine", conn), completedJobName, completedJobName));
                        if (displayCompleted == null && (se = current.getLastException()) != null) {
                            throw se;
                        }
                        this._model.getToolLogger().log(displayCompleted);
                    }
                }
            }
            catch (SQLException e) {
                this.doDebugDisplay(e.getLocalizedMessage());
            }
            finally {
                if (amILocked) {
                    try {
                        LockManager.unlock((Connection)conn);
                    }
                    catch (Exception exception) {}
                }
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                }
            }
        }
        return output;
    }

    private String getTimeZoneVersion() {
        Object timeZoneFileVersion = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpTimezoneVersion", this._model.getConn());
            if (query != null) {
                List<List<?>> theList = this.executeReturnListOfList(query, null);
                if (theList != null && theList.size() == 2 && theList.get(1).get(0) instanceof String) {
                    timeZoneFileVersion = (String)theList.get(1).get(0);
                } else if (theList != null && theList.size() >= 2 && theList.get(1).get(0) instanceof String) {
                    for (int i = 1; i < theList.size(); ++i) {
                        timeZoneFileVersion = System.lineSeparator() + (String)theList.get(i).get(0);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return timeZoneFileVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<?>> executeReturnListOfList(String query, Map<String, String> binds) throws SQLException {
        List rtn = null;
        if (LockManager.lock((Connection)this._model.getConn())) {
            try {
                DBUtil dbUtil = DBUtil.getInstance((Connection)this._model.getConn());
                rtn = dbUtil.executeReturnListofList(query, binds);
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            finally {
                LockManager.unlock((Connection)this._model.getConn());
            }
        }
        return rtn;
    }

    private void doDebug(String msg) {
        if (this._model.isDebug()) {
            this._model.getToolLogger().log(msg);
        }
    }

    private void doDebugDisplay(String msg) {
        this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_INFORMATIONAL_MESSAGE", msg));
    }
}

