/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.Preferences;
import oracle.ide.webbrowser.ProxyOptionsFilter;
import oracle.ide.webbrowser.internal.Util;
import oracle.ideimpl.webbrowser.IdeProxySelector;
import oracle.ideimpl.webbrowser.SystemProxySettings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class ProxyOptions
extends ChangeEventSource
implements Copyable {
    private static final Logger LOG = Logger.getLogger(ProxyOptions.class.getName());
    public static final String KEY_SETTINGS = "proxy-options";
    public static final String PROPERTY_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_PROXY_EXCEPTIONS = "http.nonProxyHosts";
    public static final String DEFAULT_PROXY_PORT = "80";
    private static final String PROPERTY_PROXY_USERNAME = "http.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME2 = "http.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PROPERTY_PROXY_HOST_SECURE = "https.proxyHost";
    private static final String PROPERTY_PROXY_PORT_SECURE = "https.proxyPort";
    private static final String PROPERTY_PROXY_USERNAME_SECURE = "https.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME_SECURE2 = "https.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD_SECURE = "https.proxyPassword";
    private static final String IS_IDE_PROXY = "IsIdeProxy";
    private static final ProxyOptionsFilter _defaultFilter;
    private static ProxyOptionsFilter _filter;
    private static ProxyOptions INSTANCE;
    private static final String PROXY_EXCEPTION_SEPARATOR = "|";
    private static String DEFAULT_PROXY_EXCEPTIONS;
    static final String[] LOCAL_PROXY_EXCEPTIONS;
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_EXCEPTIONS = "proxyExceptions";
    private static final String PROXY_TYPE = "proxyType";
    private static final String USE_PROXY = "useProxy";
    private static final String USE_SYSTEM_PROXY = "useSystemProxy";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_USER_NAME = "proxyUserName";
    private static final String PROXY_PASSWORD = "proxyData";
    private static final String AUTO_CONFIG_SCRIPT = "autoConfigScript";
    public static Lock doTaskLock;

    public ProxyOptions() {
    }

    protected ProxyOptions(HashStructure hash) {
        super(hash);
    }

    public static ProxyOptions getInstance(PropertyStorage prefs) {
        return new ProxyOptions(ProxyOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public static final synchronized ProxyOptions getProxyOptions() throws TransientMarker {
        if (INSTANCE == null) {
            Preferences prefs = Preferences.getPreferences();
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
            boolean settingsUninitialized = prefs.getProperties().keyStatus(KEY_SETTINGS) == 2;
            proxyOptions.setIsIdeProxy(Boolean.TRUE);
            if (settingsUninitialized) {
                proxyOptions.setProxyType(ProxyType.SYSTEM_PROXY);
            }
            INSTANCE = proxyOptions;
        }
        return INSTANCE;
    }

    void setIsIdeProxy(boolean isIdeProxy) {
        this._hash.putBoolean(IS_IDE_PROXY, Boolean.valueOf(isIdeProxy).booleanValue());
    }

    public boolean getIsIdeProxy() throws TransientMarker {
        Boolean booleanVal = this._hash.getBoolean(IS_IDE_PROXY, false);
        return booleanVal;
    }

    @Deprecated
    public final boolean getUnfilteredUseSystemProxy() {
        return ProxyType.SYSTEM_PROXY.equals((Object)this.getUnfilteredProxyType());
    }

    boolean isDefaultFilter() {
        return this.getFilter() instanceof DefaultProxyOptionsFilter;
    }

    public ProxyOptionsFilter getFilter() {
        if (this.getIsIdeProxy()) {
            return _filter;
        }
        return _defaultFilter;
    }

    public synchronized void setFilter(ProxyOptionsFilter filter) {
        if (this.getIsIdeProxy()) {
            _filter = filter == null ? _defaultFilter : filter;
        }
    }

    static void initializeProxyOptionsFromSystemProperties(ProxyOptions proxyOptions) {
        String proxyHostIn = System.getProperty(PROPERTY_PROXY_HOST);
        if (proxyHostIn != null) {
            String proxyExceptionsIn;
            String proxyPortIn = System.getProperty(PROPERTY_PROXY_PORT);
            if (proxyPortIn == null || proxyPortIn.length() == 0) {
                proxyPortIn = DEFAULT_PROXY_PORT;
            }
            if ((proxyExceptionsIn = System.getProperty(PROPERTY_PROXY_EXCEPTIONS)) == null) {
                proxyExceptionsIn = DEFAULT_PROXY_EXCEPTIONS;
            }
            proxyOptions.setProxyType(ProxyType.MANUAL_PROXY);
            proxyOptions.setProxyHost(proxyHostIn);
            proxyOptions.setProxyPort(proxyPortIn);
            proxyOptions.setProxyExceptions(proxyExceptionsIn);
        } else {
            proxyOptions.setProxyType(ProxyType.DIRECT_CONNECTION);
        }
        if (proxyOptions.getUseProxy().booleanValue()) {
            String proxyExceptions = proxyOptions.getProxyExceptions();
            proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(proxyExceptions);
            proxyOptions.setProxyExceptions(proxyExceptions);
        }
    }

    static boolean containsException(String[] currentExceptions, String exception) {
        boolean retval = false;
        if (currentExceptions != null && currentExceptions.length != 0 && exception.length() > 0) {
            for (String currentException : currentExceptions) {
                if (!currentException.equals(exception)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    static String normalizeExceptions(String exceptions) {
        String normalizedExceptions = exceptions;
        if (normalizedExceptions == null || normalizedExceptions.trim().length() == 0) {
            normalizedExceptions = DEFAULT_PROXY_EXCEPTIONS;
        } else {
            normalizedExceptions = normalizedExceptions.toLowerCase();
            normalizedExceptions = normalizedExceptions.replaceAll(",", PROXY_EXCEPTION_SEPARATOR);
            if (PlatformUtils.isWindows()) {
                normalizedExceptions = normalizedExceptions.replaceAll(";", PROXY_EXCEPTION_SEPARATOR);
            }
            normalizedExceptions = normalizedExceptions.replaceAll(" ", "");
            normalizedExceptions = normalizedExceptions.replaceAll("\\[", "");
            normalizedExceptions = normalizedExceptions.replaceAll("\\]", "");
        }
        return normalizedExceptions;
    }

    public static String[] splitExceptionsIntoArray(String exceptions) {
        String[] currentExceptions = null;
        if (ModelUtil.hasLength((String)exceptions)) {
            currentExceptions = exceptions.split("\\|");
        }
        return currentExceptions;
    }

    private static List<String> getLocalExceptions() {
        ArrayList<String> localExceptions = new ArrayList<String>(LOCAL_PROXY_EXCEPTIONS.length);
        for (String exception : LOCAL_PROXY_EXCEPTIONS) {
            localExceptions.add(exception);
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            String name = address.getCanonicalHostName();
            if (name != null) {
                localExceptions.add(name);
            }
            if ((name = address.getHostName()) != null) {
                localExceptions.add(name);
            }
            if ((name = address.getHostAddress()) != null) {
                localExceptions.add(name);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localExceptions;
    }

    public static String ensureLocalExceptionsAdded(String proxyExceptions) {
        String normalizedExceptions = ProxyOptions.normalizeExceptions(proxyExceptions);
        String[] currentExceptions = ProxyOptions.splitExceptionsIntoArray(normalizedExceptions);
        StringBuffer sb = ModelUtil.hasLength((String)normalizedExceptions) ? new StringBuffer(normalizedExceptions) : new StringBuffer();
        List<String> localExceptions = ProxyOptions.getLocalExceptions();
        for (String exception : localExceptions) {
            if (ProxyOptions.containsException(currentExceptions, exception)) continue;
            if (sb.length() > 0) {
                sb.append(PROXY_EXCEPTION_SEPARATOR);
            }
            sb.append(exception);
        }
        return sb.toString();
    }

    public static final void setProxyOptions(ProxyOptions proxyOptions) throws TransientMarker {
        ProxyOptions p = ProxyOptions.getProxyOptions();
        proxyOptions.copyTo((Object)p);
    }

    public final void setProxyHost(String newProxyHost) {
        this._hash.putString(PROXY_HOST, newProxyHost);
    }

    public final String getProxyHost() {
        return this.getFilter().getProxyHost(this.getUnfilteredProxyHost());
    }

    public final String getUnfilteredProxyHost() {
        return this.getUnfilteredUseSystemProxy() ? SystemProxySettings.getSystemProxyHost() : this._hash.getString(PROXY_HOST);
    }

    public final void setProxyPort(String newProxyPort) {
        this._hash.putString(PROXY_PORT, newProxyPort);
    }

    public final String getProxyPort() {
        return this.getFilter().getProxyPort(this.getUnfilteredProxyPort());
    }

    public final String getUnfilteredProxyPort() {
        String proxyPort;
        String string = proxyPort = this.getUnfilteredUseSystemProxy() ? SystemProxySettings.getSystemProxyPort() : this._hash.getString(PROXY_PORT);
        if (proxyPort == null) {
            proxyPort = DEFAULT_PROXY_PORT;
        }
        return proxyPort;
    }

    public final void setProxyExceptions(String newProxyExceptions) {
        this._hash.putString(PROXY_EXCEPTIONS, newProxyExceptions);
    }

    public final String getProxyExceptions() {
        return this.getFilter().getProxyExceptions(this.getUnfilteredProxyExceptions());
    }

    public final String getUnfilteredProxyExceptions() {
        return this.getUnfilteredUseSystemProxy() ? SystemProxySettings.getSystemProxyExceptions() : this._hash.getString(PROXY_EXCEPTIONS);
    }

    public final void setProxyType(ProxyType type) {
        this._hash.putString(PROXY_TYPE, type.toString());
    }

    public ProxyType getProxyType() {
        return this.getFilter().getProxyType(this.getUnfilteredProxyType());
    }

    public ProxyType getUnfilteredProxyType() {
        String proxyTypeString = this._hash.getString(PROXY_TYPE);
        if (proxyTypeString == null) {
            Boolean useProxy = this._hash.getBoolean(USE_PROXY);
            Boolean useSystemProxy = this._hash.getBoolean(USE_SYSTEM_PROXY);
            proxyTypeString = useSystemProxy != null && useSystemProxy != false ? ProxyType.SYSTEM_PROXY.toString() : (useProxy != null && useProxy != false ? ProxyType.MANUAL_PROXY.toString() : ProxyType.DIRECT_CONNECTION.toString());
            this._hash.putString(PROXY_TYPE, proxyTypeString);
            this._hash.remove(USE_PROXY);
            this._hash.remove(USE_SYSTEM_PROXY);
        }
        return ProxyType.valueOf(proxyTypeString);
    }

    @Deprecated
    public final void setUseProxy(Boolean newUseProxy) {
        this.setProxyType(newUseProxy != null && newUseProxy != false ? ProxyType.MANUAL_PROXY : ProxyType.DIRECT_CONNECTION);
    }

    public Boolean getUseProxy() {
        return this.getFilter().getUseProxy(this.getUnfilteredUseProxy());
    }

    @Deprecated
    public final void setUseSystemProxy(Boolean newUseSystemProxy) {
        if (newUseSystemProxy != null && newUseSystemProxy.booleanValue()) {
            this.setProxyType(ProxyType.SYSTEM_PROXY);
        }
    }

    @Deprecated
    public Boolean getUseSystemProxy() {
        return this.getFilter().getUseSystemProxy(this.getUnfilteredUseSystemProxy());
    }

    public Boolean getUnfilteredUseProxy() {
        ProxyType unfilteredType = this.getUnfilteredProxyType();
        if (unfilteredType.equals((Object)ProxyType.SYSTEM_PROXY)) {
            return !SystemProxySettings.isDirectConnectionType();
        }
        return !unfilteredType.equals((Object)ProxyType.DIRECT_CONNECTION);
    }

    public final void setUseProxyAuthentication(Boolean newUseProxyAuthentication) {
        if (newUseProxyAuthentication != null) {
            this._hash.putBoolean(USE_PROXY_AUTHENTICATION, newUseProxyAuthentication.booleanValue());
        } else {
            this._hash.remove(USE_PROXY_AUTHENTICATION);
        }
    }

    public Boolean getUseProxyAuthentication() {
        return this.getFilter().getUseProxyAuthentication(this.getUnfilteredUseProxyAuthentication());
    }

    public Boolean getUnfilteredUseProxyAuthentication() {
        return this._hash.getBoolean(USE_PROXY_AUTHENTICATION);
    }

    public final void setProxyUserName(String newProxyUserName) {
        this._hash.putString(PROXY_USER_NAME, newProxyUserName);
    }

    public final String getProxyUserName() {
        return this.getFilter().getProxyUserName(this.getUnfilteredProxyUserName());
    }

    public final String getUnfilteredProxyUserName() {
        return this._hash.getString(PROXY_USER_NAME);
    }

    public final void setProxyPassword(char[] newProxyPassword) {
        try {
            String encodedPassword = Util.encode(newProxyPassword);
            if (encodedPassword == null) {
                throw new IllegalStateException("Proxy password is null.");
            }
            this._hash.putString(PROXY_PASSWORD, encodedPassword);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to set proxy password", e);
            this._hash.putString(PROXY_PASSWORD, "");
        }
    }

    public final char[] getProxyPassword() throws TransientMarker {
        return this.getFilter().getProxyPassword(this.getUnfilteredProxyPassword());
    }

    public final char[] getUnfilteredProxyPassword() throws TransientMarker {
        char[] result = null;
        try {
            String encodedPassword = this._hash.getString(PROXY_PASSWORD);
            result = Util.decodeCharArray(encodedPassword);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to get proxy password", e);
        }
        return result != null ? result : new char[]{};
    }

    public final void setProxyData(String newData) {
        this._hash.putString(PROXY_PASSWORD, newData);
    }

    public final String getProxyData() {
        return this.getFilter().getProxyData(this.getUnfilteredProxyData());
    }

    public final String getUnfilteredProxyData() {
        return this._hash.getString(PROXY_PASSWORD);
    }

    public final void setAutoConfigScript(String newAutoConfigScript) {
        if (newAutoConfigScript != null) {
            this._hash.putString(AUTO_CONFIG_SCRIPT, newAutoConfigScript);
        } else {
            this._hash.remove(AUTO_CONFIG_SCRIPT);
        }
    }

    public String getAutoConfigScript() {
        return this.getFilter().getAutoConfigScript(this.getUnfilteredAutoConfigScript());
    }

    public String getUnfilteredAutoConfigScript() {
        return this._hash.getString(AUTO_CONFIG_SCRIPT);
    }

    public String[] getJavaProxyOptions() {
        String proxyHost;
        Boolean useProxy = this.getUseProxy();
        if (useProxy != null && useProxy.booleanValue() && (proxyHost = this.getProxyHost()) != null && proxyHost.length() > 0) {
            String[] jpo = new String[5];
            jpo[0] = "-Dhttp.proxyHost=" + proxyHost;
            String proxyPort = this.getProxyPort();
            String port = proxyPort != null && proxyPort.length() > 0 ? proxyPort : DEFAULT_PROXY_PORT;
            jpo[1] = "-Dhttp.proxyPort=" + port;
            String proxyExceptions = this.getProxyExceptions();
            jpo[2] = "-Dhttp.nonProxyHosts=" + proxyExceptions;
            jpo[3] = "-Dhttps.proxyHost=" + proxyHost;
            jpo[4] = "-Dhttps.proxyPort=" + port;
            return jpo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask(Runnable r) {
        doTaskLock.lock();
        try {
            ProxyOptions saved = ProxyOptions.getProxyOptions();
            try {
                this.applyToCurrentVM();
                IdeProxySelector.setTemporaryProxyOptions(this);
                r.run();
            }
            finally {
                IdeProxySelector.clearTemporaryProxyOptions();
                saved.applyToCurrentVM();
            }
        }
        finally {
            doTaskLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToCurrentVM() {
        Class<ProxyOptions> clazz = ProxyOptions.class;
        synchronized (ProxyOptions.class) {
            block14: {
                Boolean useProxyBoolean = this.getUseProxy();
                boolean useProxy = useProxyBoolean != null ? useProxyBoolean : false;
                String proxyHost = this.getProxyHost();
                String proxyExceptions = this.getProxyExceptions();
                Boolean useProxyAuthBoolean = this.getUseProxyAuthentication();
                boolean useProxyAuth = useProxyAuthBoolean != null ? useProxyAuthBoolean : false;
                String proxyUserName = this.getProxyUserName();
                char[] proxyPassword = this.getProxyPassword();
                if (useProxy && proxyHost != null && proxyHost.length() > 0) {
                    String proxyPort = this.getProxyPort();
                    if (proxyPort == null || proxyPort.length() == 0) {
                        proxyPort = DEFAULT_PROXY_PORT;
                    }
                    if (proxyExceptions == null) {
                        proxyExceptions = "";
                    }
                    try {
                        System.setProperty(PROPERTY_PROXY_HOST, proxyHost);
                        System.setProperty(PROPERTY_PROXY_PORT, proxyPort);
                        System.setProperty(PROPERTY_PROXY_EXCEPTIONS, proxyExceptions);
                        System.setProperty(PROPERTY_PROXY_HOST_SECURE, proxyHost);
                        System.setProperty(PROPERTY_PROXY_PORT_SECURE, proxyPort);
                        if (useProxyAuth && proxyUserName != null && proxyPassword != null) {
                            System.setProperty(PROPERTY_PROXY_USERNAME, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_USERNAME2, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_PASSWORD, new String(proxyPassword));
                            System.setProperty(PROPERTY_PROXY_USERNAME_SECURE, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_USERNAME_SECURE2, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_PASSWORD_SECURE, new String(proxyPassword));
                            for (int j = 0; j < proxyPassword.length; ++j) {
                                proxyPassword[j] = 32;
                            }
                            break block14;
                        }
                        if (useProxyAuth) {
                            this.setUseProxyAuthentication(Boolean.FALSE);
                        }
                        System.clearProperty(PROPERTY_PROXY_USERNAME);
                        System.clearProperty(PROPERTY_PROXY_USERNAME2);
                        System.clearProperty(PROPERTY_PROXY_PASSWORD);
                        System.clearProperty(PROPERTY_PROXY_USERNAME_SECURE);
                        System.clearProperty(PROPERTY_PROXY_USERNAME_SECURE2);
                        System.clearProperty(PROPERTY_PROXY_PASSWORD_SECURE);
                    }
                    catch (SecurityException e) {
                        LOG.log(Level.SEVERE, "Could not set proxy setting", e);
                    }
                } else {
                    try {
                        System.clearProperty(PROPERTY_PROXY_HOST);
                        System.clearProperty(PROPERTY_PROXY_PORT);
                        System.clearProperty(PROPERTY_PROXY_EXCEPTIONS);
                        System.clearProperty(PROPERTY_PROXY_HOST_SECURE);
                        System.clearProperty(PROPERTY_PROXY_PORT_SECURE);
                        System.clearProperty(PROPERTY_PROXY_USERNAME);
                        System.clearProperty(PROPERTY_PROXY_USERNAME2);
                        System.clearProperty(PROPERTY_PROXY_PASSWORD);
                        System.clearProperty(PROPERTY_PROXY_USERNAME_SECURE);
                        System.clearProperty(PROPERTY_PROXY_USERNAME_SECURE2);
                        System.clearProperty(PROPERTY_PROXY_PASSWORD_SECURE);
                    }
                    catch (SecurityException e) {
                        LOG.log(Level.SEVERE, "Could not remove proxy setting", e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean equals(Object other) {
        boolean equal = true;
        if (other instanceof ProxyOptions) {
            ProxyOptions copy = (ProxyOptions)((Object)other);
            if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyExceptions(), (Object)copy.getUnfilteredProxyExceptions())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyHost(), (Object)copy.getUnfilteredProxyHost())) {
                equal = false;
            } else if (!Arrays.equals(this.getUnfilteredProxyPassword(), copy.getUnfilteredProxyPassword())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyPort(), (Object)copy.getUnfilteredProxyPort())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyUserName(), (Object)copy.getUnfilteredProxyUserName())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)((Object)this.getUnfilteredProxyType()), (Object)((Object)copy.getUnfilteredProxyType()))) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredUseProxyAuthentication(), (Object)copy.getUnfilteredUseProxyAuthentication())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredAutoConfigScript(), (Object)copy.getUnfilteredAutoConfigScript())) {
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public Object copyTo(Object target) {
        ProxyOptions copy = target != null ? (ProxyOptions)((Object)target) : new ProxyOptions();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ProxyOptions copy) {
        if (!this.equals((Object)copy)) {
            copy.setProxyExceptions(this.getUnfilteredProxyExceptions());
            copy.setProxyHost(this.getUnfilteredProxyHost());
            copy.setProxyPassword(this.getUnfilteredProxyPassword());
            copy.setProxyPort(this.getUnfilteredProxyPort());
            copy.setProxyUserName(this.getUnfilteredProxyUserName());
            copy.setProxyType(this.getUnfilteredProxyType());
            copy.setUseProxyAuthentication(this.getUnfilteredUseProxyAuthentication());
            copy.setAutoConfigScript(this.getUnfilteredAutoConfigScript());
            copy.fireChangeEvent();
        }
    }

    static {
        _filter = _defaultFilter = new DefaultProxyOptionsFilter();
        DEFAULT_PROXY_EXCEPTIONS = "";
        LOCAL_PROXY_EXCEPTIONS = new String[]{"localhost", "localhost.localdomain", "127.0.0.1", "[::1]"};
        doTaskLock = new ReentrantLock();
    }

    public static enum ProxyType {
        DIRECT_CONNECTION,
        SYSTEM_PROXY,
        MANUAL_PROXY,
        PAC;

    }

    private static class DefaultProxyOptionsFilter
    extends ProxyOptionsFilter {
        private DefaultProxyOptionsFilter() {
        }

        @Override
        public String getLabel() {
            return "DefaultProxyOptionsFilter";
        }
    }
}

