/*
 * Decompiled with CFR 0.152.
 */
package ice.util.image;

import ice.util.image.IceImageObserver;
import ice.util.image.ImageObserverProxy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

public class ImageProxy {
    byte[] realImageData = null;
    private Image theImage = null;
    private ImageObserverProxy theObserver = null;

    ImageProxy(Image theWrappedImage) {
        this.theImage = theWrappedImage;
    }

    public Image getImage() {
        return this.theImage;
    }

    public ImageObserver registerListener(IceImageObserver iio) {
        if (this.theObserver != null && iio != null) {
            this.theObserver.registerListener(iio);
            return this.theObserver;
        }
        return null;
    }

    void setImageObserver(ImageObserverProxy io) {
        this.theObserver = io;
    }

    public int getHeight(ImageObserver observer) {
        if (this.theImage != null) {
            return this.theImage.getHeight(observer);
        }
        return -1;
    }

    public int getWidth(ImageObserver observer) {
        if (this.theImage != null) {
            return this.theImage.getWidth(observer);
        }
        return -1;
    }

    public ImageProducer getSource() {
        return null;
    }

    public Graphics getGraphics() {
        if (this.theImage != null) {
            return this.theImage.getGraphics();
        }
        return null;
    }

    public Object getProperty(String name, ImageObserver observer) {
        if (this.theImage != null) {
            return this.theImage.getProperty(name, observer);
        }
        return null;
    }

    public Image getScaledInstance(int width, int height, int hints) {
        if (this.theImage != null) {
            return this.theImage.getScaledInstance(width, height, hints);
        }
        return null;
    }

    public void flush() {
        if (this.theImage != null) {
            this.theImage.flush();
        }
        if (this.theObserver != null) {
            this.theObserver.dispose();
            this.theObserver = null;
        }
    }

    public boolean compareImage(Image img) {
        return img == this.theImage;
    }
}

