/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import ice.ri.common.dialog.SettingsDialogPanelGroup;
import ice.ri.common.dialog.awt.AbstractSettingsDialog;
import ice.ri.common.dialog.awt.AbstractSettingsDialogPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class ListSettingsDialog
extends AbstractSettingsDialog
implements ItemListener {
    private Panel settingsPanel;
    private CardLayout cardLayout = new CardLayout();
    private List panelList;
    private GridBagConstraints constraints;
    private Panel buttonPanel;

    public ListSettingsDialog(Frame parent, String title) {
        super(parent, title);
        this.settingsPanel = new Panel(this.cardLayout);
        this.panelList = new List(5, false);
        this.panelList.addItemListener(this);
    }

    public void setGui() {
        ScrollPane listScrollPane = new ScrollPane(0);
        listScrollPane.add(this.panelList);
        this.add((Component)this.settingsPanel, "Center");
        this.add((Component)listScrollPane, "West");
        GridBagLayout layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.buttonPanel = new Panel(layout);
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this.okButton, 1, 1);
        this.addGB(this.cancelButton, 2, 1);
        if (this.displayType == 1) {
            this.addGB(this.applyButton, 3, 1);
        }
        this.add((Component)this.buttonPanel, "South");
    }

    public void setListPaneSize(int width, int height) {
        this.panelList.setSize(new Dimension(width, height));
    }

    public void add(AbstractSettingsDialogPanel panel) {
        super.add(panel);
        this.settingsPanel.add((Component)panel, panel.getName());
        this.panelList.add(panel.getName());
    }

    public void add(SettingsDialogPanelGroup group) {
        super.add(group);
        Vector groupPanels = group.getPanels();
        Enumeration panels = groupPanels.elements();
        while (panels.hasMoreElements()) {
            AbstractSettingsDialogPanel tmp = (AbstractSettingsDialogPanel)panels.nextElement();
            this.settingsPanel.add((Component)tmp, tmp.getName());
            this.panelList.add(tmp.getName());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String selectedTerm = this.panelList.getSelectedItem();
        if (selectedTerm != null) {
            this.cardLayout.show(this.settingsPanel, selectedTerm);
        }
    }

    private void addGB(Component component, int x, int y) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.buttonPanel.add(component, this.constraints);
    }
}

