/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.ddl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import oracle.dbtools.jdv.ddl.Quoting;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.graphql.GQLParser;
import oracle.dbtools.parser.plsql.SqlEarley;

public class GQLProcessor {
    public static final String IDENTIFIER = "identifier";
    public static final String SELECTION_SET = "selectionSet";
    public static final String ARGUMENT = "argument";
    public static final String ARGUMENTS = "arguments";

    public static JDVElement getDVRootDefinition(String input) throws IOException {
        Object earley = null;
        earley = input.toUpperCase(Locale.ROOT).indexOf("SELECT ") > -1 ? SqlEarley.getInstance() : GQLParser.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, matrix);
        ParseNode node = earley.forest(src, matrix);
        JDVElement root = null;
        JDVElement current = null;
        boolean rootFound = false;
        Stack<JDVElement> stack = new Stack<JDVElement>();
        ArrayList<String> createTokens = new ArrayList<String>();
        for (ParseNode n : node.descendants()) {
            String token;
            if (n.contains("gqlField")) {
                if (rootFound || GQLProcessor.isTableField(n)) {
                    rootFound = true;
                    JDVElement el = new JDVElement();
                    GQLProcessor.processField(el, src, n);
                    if (el.isTable()) {
                        if (root == null) {
                            root = el;
                            current = el;
                        } else {
                            if (current != null) {
                                current.getElements().add(el);
                            }
                            stack.push(current);
                            current = el;
                        }
                    } else if (current != null) {
                        current.getElements().add(el);
                    }
                } else if (n.contains(IDENTIFIER)) {
                    token = GQLProcessor.getContent(n, src);
                    createTokens.add(token);
                }
            } else if (!rootFound && n.contains(IDENTIFIER)) {
                token = GQLProcessor.getContent(n, src);
                createTokens.add(token);
            }
            if (current == null || n.to - n.from != 1 || n.to != current.getParseTo() || current == root) continue;
            current = (JDVElement)stack.pop();
        }
        if (root != null) {
            root.synchPropsToVarsForTree();
            GQLProcessor.reconstructNested(root);
        }
        return root;
    }

    static void reconstructNested(JDVElement root) {
        ArrayList<JDVElement> source = new ArrayList<JDVElement>(root.getElements());
        for (JDVElement el : source) {
            if (!el.isTable()) continue;
            if (el.isNested()) {
                if (!GQLProcessor.equalTables(el, root)) continue;
                GQLProcessor.changeNested(root, el);
                root.getElements().remove(el);
                continue;
            }
            GQLProcessor.reconstructNested(el);
        }
    }

    static void changeNested(JDVElement parent, JDVElement el) {
        List<JDVElement> list = parent.getElements();
        int ind = list.indexOf(el);
        String nested_key = el.getJson_key_name();
        for (int i = el.getElements().size() - 1; i >= 0; --i) {
            JDVElement column = el.getElements().get(i);
            column.setNestedKey(nested_key);
            list.add(ind, column);
        }
    }

    static boolean equalTables(JDVElement t1, JDVElement t2) {
        return t1.isTable() && t2.isTable() && t1.getTable_name().equals(t2.getTable_name()) && (t1.getTable_owner() == null && t2.getTable_owner() == null || t1.getTable_owner().equals(t2.getTable_owner()));
    }

    static boolean isTableField(ParseNode pn) {
        for (ParseNode n : pn.children()) {
            if (!n.contains(SELECTION_SET)) continue;
            return true;
        }
        return false;
    }

    static void processField(JDVElement el, List<LexerToken> src, ParseNode pn) {
        boolean table = GQLProcessor.isTableField(pn);
        el.setObjectType(table ? "TABLE" : "COLUMN");
        if (pn.children().size() == 0 && pn.contains(IDENTIFIER)) {
            String name = GQLProcessor.getContent(pn, src);
            if (table) {
                el.setTable_name(name);
            } else {
                el.setColumn_name(name);
            }
        }
        int ind = 0;
        for (ParseNode n : pn.children()) {
            if (n.contains(SELECTION_SET)) {
                el.setParseFrom(n.from);
                el.setParseTo(n.to);
                return;
            }
            if (n.contains("alias")) {
                GQLProcessor.processAlias(el, src, n);
                continue;
            }
            ++ind;
            if (n.contains(IDENTIFIER)) {
                String name = GQLProcessor.getContent(n, src);
                if (ind == 1) {
                    if (table) {
                        el.setTable_name(name);
                    } else {
                        el.setColumn_name(name);
                    }
                } else {
                    el.setTable_owner(el.getTable_name());
                    el.setTable_name(name);
                }
            }
            if (n.contains("directive")) {
                GQLProcessor.processDirective(el, src, n);
                continue;
            }
            if (!n.contains("directives")) continue;
            GQLProcessor.processDirectives(el, src, n);
        }
    }

    static void processAlias(JDVElement el, List<LexerToken> src, ParseNode pn) {
        for (ParseNode n : pn.children()) {
            if (!n.contains(IDENTIFIER)) continue;
            String name = GQLProcessor.getContent(n, src);
            el.setJson_key_name(name);
        }
    }

    static void processDirectives(JDVElement el, List<LexerToken> src, ParseNode pn) {
        for (ParseNode n : pn.children()) {
            if (n.contains("directive")) {
                GQLProcessor.processDirective(el, src, n);
                continue;
            }
            if (n.contains(IDENTIFIER)) {
                String clause = GQLProcessor.getContent(n, src);
                GQLProcessor.setSimpleClause(el, clause);
                continue;
            }
            if (n.children().size() <= 0) continue;
            GQLProcessor.processDirectives(el, src, n);
        }
    }

    static void processDirective(JDVElement el, List<LexerToken> src, ParseNode n) {
        for (ParseNode node : n.children()) {
            if (!node.contains(IDENTIFIER)) continue;
            String clause = GQLProcessor.getContent(node, src);
            if ("FLEX".equalsIgnoreCase(clause)) {
                GQLProcessor.processFlexClause(el, src, n);
                continue;
            }
            if ("LINK".equalsIgnoreCase(clause)) {
                GQLProcessor.processLinkClause(el, src, n);
                continue;
            }
            if ("WHERE".equalsIgnoreCase(clause)) {
                GQLProcessor.processWhereClause(el, src, n);
                continue;
            }
            GQLProcessor.setSimpleClause(el, clause);
        }
    }

    private static void processFlexClause(JDVElement el, List<LexerToken> src, ParseNode pn) {
        el.setIs_flex_col("true");
        for (ParseNode n : pn.children()) {
            if (!n.contains(ARGUMENTS)) continue;
            for (ParseNode v : n.children()) {
                if (!v.contains(ARGUMENT)) continue;
                for (ParseNode node : v.children()) {
                    if (!node.contains("value")) continue;
                    String value = GQLProcessor.getContent(node, src);
                    el.setConflictResolutionOnFlex(value.toUpperCase(Locale.ROOT));
                }
            }
        }
    }

    private static void processWhereClause(JDVElement el, List<LexerToken> src, ParseNode pn) {
        for (ParseNode n : pn.children()) {
            if (!n.contains(ARGUMENTS)) continue;
            for (ParseNode v : n.children()) {
                if (!v.contains(ARGUMENT)) continue;
                for (ParseNode node : v.children()) {
                    if (!node.contains("value")) continue;
                    String value = GQLProcessor.getContent(node, src);
                    el.setTableFilter(Quoting.unQuote(value));
                }
            }
        }
    }

    private static void processLinkClause(JDVElement el, List<LexerToken> src, ParseNode pn) {
        String fromTo = null;
        Object fkColumns = null;
        for (ParseNode n : pn.children()) {
            if (!n.contains(ARGUMENTS)) continue;
            for (ParseNode v : n.children()) {
                if (!v.contains(ARGUMENT)) continue;
                for (ParseNode node : v.children()) {
                    if (node.contains(IDENTIFIER)) {
                        String value;
                        fromTo = value = GQLProcessor.getContent(node, src);
                    }
                    if (!node.contains("arrayValue") && !node.contains("value")) continue;
                    for (ParseNode nn : node.children()) {
                        if (nn.contains(IDENTIFIER)) {
                            String value = GQLProcessor.getContent(nn, src);
                            if (fkColumns == null) {
                                fkColumns = value;
                                continue;
                            }
                            fkColumns = (String)fkColumns + "," + value;
                            continue;
                        }
                        if (nn.children().size() <= 0) continue;
                        for (ParseNode t : nn.children()) {
                            if (!t.contains(IDENTIFIER)) continue;
                            String value = GQLProcessor.getContent(t, src);
                            if (fkColumns == null) {
                                fkColumns = value;
                                continue;
                            }
                            fkColumns = (String)fkColumns + "," + value;
                        }
                    }
                }
            }
        }
        if (fromTo != null) {
            if ("to".equalsIgnoreCase(fromTo)) {
                el.setFkColumns((String)fkColumns);
            } else if ("from".equalsIgnoreCase(fromTo)) {
                el.setOther_FkColumns((String)fkColumns);
            }
        }
    }

    public static void setSimpleClause(JDVElement el, String clause) {
        String test;
        switch (test = clause.toUpperCase(Locale.ROOT)) {
            case "CHECK": 
            case "NOCHECK": {
                el.setCheck("CHECK".equals(test) ? "true" : "false");
                return;
            }
            case "INSERT": 
            case "NOINSERT": {
                el.setAllow_insert("INSERT".equals(test) ? "true" : "false");
                return;
            }
            case "UPDATE": 
            case "NOUPDATE": {
                el.setAllow_update("UPDATE".equals(test) ? "true" : "false");
                return;
            }
            case "DELETE": 
            case "NODELETE": {
                el.setAllow_delete("DELETE".equals(test) ? "true" : "false");
                return;
            }
            case "UNNEST": {
                el.setUnnested("true");
                return;
            }
            case "NEST": {
                el.setNested("true");
                return;
            }
        }
    }

    public static ParseNode parseInput(String input) throws IOException {
        Object earley = null;
        earley = input.toUpperCase(Locale.ROOT).indexOf("SELECT ") > -1 ? SqlEarley.getInstance() : GQLParser.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        return earley.forest(src, matrix);
    }

    public static void printParsed(String input) throws IOException {
        Object earley = null;
        earley = input.toUpperCase(Locale.ROOT).indexOf("SELECT ") > -1 ? SqlEarley.getInstance() : GQLParser.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, matrix);
        ParseNode node = earley.forest(src, matrix);
        for (ParseNode n : node.descendants()) {
            GQLProcessor.printNode(n, src);
        }
    }

    static void printNode(ParseNode n, List<LexerToken> src) {
        Object desc = n.toString();
        String cont = GQLProcessor.getContent(n, src);
        desc = (String)desc;
        if (n.contains(IDENTIFIER)) {
            desc = (String)desc + " - " + cont;
        }
        System.out.print("\n" + (String)desc);
    }

    public static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            if (pn.to - pn.from == 1) {
                return src.get((int)pn.from).content;
            }
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content + "\n");
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

