/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;

public class FileUtils {
    public static final String SEPARATOR = "...";

    public static String longToShortPath(String path, int limit) {
        int free;
        int i;
        if (path == null) {
            return "";
        }
        if (path.length() <= limit) {
            return path;
        }
        char[] shortPathArray = new char[limit];
        char[] pathArray = path.toCharArray();
        char[] separatorArray = SEPARATOR.toCharArray();
        int pathindex = pathArray.length - 1;
        int shortpathindex = limit - 1;
        for (i = 0; i <= limit; ++i) {
            if (pathArray[pathindex - i] == '/' || pathArray[pathindex - i] == '\\') {
                shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
                break;
            }
            shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
        }
        if ((free = limit - i) < SEPARATOR.length()) {
            for (int j = 0; j < separatorArray.length; ++j) {
                shortPathArray[j] = separatorArray[j];
            }
        } else {
            int j = 0;
            while (j + separatorArray.length < free - 1) {
                shortPathArray[j] = pathArray[j];
                ++j;
            }
            int k = 0;
            while (j + k < free - 1) {
                shortPathArray[j + k] = separatorArray[k];
                ++k;
            }
        }
        return new String(shortPathArray);
    }

    public static String addLastSlash(String path) {
        if (!path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    public static String fixPath(String path) {
        if (path != null) {
            return path.replaceAll("[\\\\]", "/");
        }
        return path;
    }

    public static String removeExt(String name) {
        int dotPos = name.lastIndexOf(46);
        if (dotPos == -1) {
            return name;
        }
        return name.substring(0, dotPos);
    }

    public static void copyFolder(final Path sourceDir, final Path targetDir) throws IOException {
        Files.walkFileTree(sourceDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block3: {
                    Path target = targetDir.resolve(sourceDir.relativize(dir));
                    if (target.endsWith(".svn")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    try {
                        Files.copy(dir, target, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(target, new LinkOption[0])) break block3;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(".svn")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Files.copy(file, targetDir.resolve(sourceDir.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

