/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Color;
import java.util.Collection;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;

public class TVRelation
extends TVConnector {
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;

    public TVRelation(DesignPartView dpv) {
        super(dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public Relation getRelation() {
        return (Relation)this.getModel();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (ObjectChangeEvent.OBJECT_REMOVED.equals(event)) {
            this.removeLabel(0);
            this.removeLabel(2);
        }
    }

    public void addConnection() {
    }

    @Override
    public void displayLabels() {
        if (this.getDesignPartView().showLabels()) {
            String sourceName = this.getRelation().getNameOnSource();
            if (!"".equalsIgnoreCase(sourceName)) {
                this.displayLabel(sourceName, this.getSourceLabelBounds(), 0);
            } else {
                this.removeLabel(0);
            }
            String targetName = this.getRelation().getNameOnTarget();
            if (!"".equalsIgnoreCase(targetName)) {
                this.displayLabel(targetName, this.getTargetLabelBounds(), 2);
            } else {
                this.removeLabel(2);
            }
        } else {
            this.removeLabel(0);
            this.removeLabel(2);
        }
    }

    public void displayRelationAttributes() {
        if (this.getDesignPartView().showRelAttributes()) {
            String attributes = this.getAttributesAsString();
            if (attributes != null) {
                this.displayLabel(attributes, this.getLabelBounds(), 1);
            } else {
                this.removeLabel(1);
            }
        } else {
            this.removeLabel(1);
        }
    }

    public String getAttributesAsString() {
        Collection collection = this.getRelation().getAttributesCollection();
        if (collection.size() > 0) {
            Object result = "";
            int p = 0;
            for (ContainedObjectWithDomain next : collection) {
                if (p > 0) {
                    result = (String)result + "\n";
                }
                ++p;
                Object rowText = !next.getNullsAllowed() ? "*" : "o";
                rowText = (String)rowText + " " + next.getName();
                int notation = this.getDesignPartView().getNotation();
                if (notation != 1) {
                    rowText = (String)rowText + "    " + ((Attribute)next).getLogicalRepresentationName();
                }
                result = (String)result + (String)rowText;
            }
            return result;
        }
        return null;
    }

    public Collection getRelationshipAttributes() {
        return this.getRelation().getAttributesCollection();
    }

    public void updateParents() {
    }

    @Override
    public void resetEdgeParams() {
    }

    public void resetEdgeParams(boolean repaint) {
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Logical Relation").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Logical Relation").getWidth();
    }
}

