/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;

public abstract class ContainerView
extends TopView {
    public static final int BORDER_N = 8;
    public static final int BORDER_NE = 7;
    public static final int BORDER_E = 11;
    public static final int BORDER_SE = 5;
    public static final int BORDER_S = 9;
    public static final int BORDER_SW = 4;
    public static final int BORDER_W = 10;
    public static final int BORDER_NW = 6;
    private static final int LEFT = 0;
    private static final int UPPER = 0;
    private static final int MIDDLE = 1;
    private static final int RIGHT = 2;
    private static final int LOWER = 2;
    Object selectedObject = null;
    private HashMap<Point2D, TVConnector> connMap = new HashMap();
    private double pdelta = 10.0;
    private String comment = "";
    double p0x;
    double p1x;
    double p2x;
    double p3x;
    double ix;
    double p0y;
    double p1y;
    double p2y;
    double p3y;
    double iy;
    boolean collisionDetected;

    public ContainerView(DesignPartView dpv) {
        super(dpv);
    }

    public ContainerView() {
    }

    public void copyBounds(TopView topView) {
        if (topView != null) {
            Rectangle r = this.getBounds();
            topView.setBounds(r);
        }
    }

    public boolean shouldShowLongNameContained() {
        return false;
    }

    @Override
    public void setModel(DesignObject object) {
        super.setModel(object);
    }

    protected int pointInBorder(Point point) {
        int cornerRange = 10;
        Rectangle rect = this.getBounds();
        int xregion = this.beginMiddleEnd(point.x, cornerRange, rect.width);
        int yregion = this.beginMiddleEnd(point.y, cornerRange, rect.height);
        switch (xregion + 7 * yregion) {
            case 0: {
                return 6;
            }
            case 7: {
                return 10;
            }
            case 14: {
                return 4;
            }
            case 2: {
                return 7;
            }
            case 9: {
                return 11;
            }
            case 16: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return 6;
    }

    private int beginMiddleEnd(int coord, int range, int max) {
        if (coord < range) {
            return 0;
        }
        if (coord > max - range) {
            return 2;
        }
        return 1;
    }

    public int minimumComponentSize() {
        return 50;
    }

    public void remove() {
        this.remove("");
    }

    public void remove(String logMessage) {
        this.remove(false);
    }

    protected boolean hasRelations() {
        return false;
    }

    protected int getPreferredIconSize() {
        return 24;
    }

    protected abstract void doPrivateActions();

    public void remove(boolean removeModel) {
        this.clearShowParentChildListeners();
        if (removeModel) {
            this.getModel().remove();
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
        }
    }

    public void removeNoneCascade(boolean removeModel) {
        if (removeModel) {
            this.getModel().remove();
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeViewNoneCascade(this);
        }
    }

    protected void fireChange(ObjectChangeEvent event) {
    }

    public void addTVTypeSubstitutions() {
    }

    protected abstract void hideRelations();

    @Override
    public boolean canRemove() {
        return true;
    }

    public Rectangle getActualBounds() {
        Rectangle bounds = this.getBounds();
        return bounds;
    }

    public void setActualBoundsRect(Rectangle rect) {
        this.location.x = rect.x;
        this.location.y = rect.y;
        this.size.width = rect.width;
        this.size.height = rect.height;
    }

    public void setActualBounds(int x, int y, int width, int height) {
        this.location.x = x;
        this.location.y = y;
        this.size.width = width;
        this.size.height = height;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment != null ? comment : "";
    }

    public Point2D getPerimeterPoint(Point2D source, Point2D p, boolean simple, boolean autoroute) {
        Rectangle bounds = this.getBounds();
        Point2D cr = this.getPerimPoint(bounds, p);
        if (cr != null) {
            return cr;
        }
        double x = ((RectangularShape)bounds).getX();
        double y = ((RectangularShape)bounds).getY();
        double width = ((RectangularShape)bounds).getWidth();
        double height = ((RectangularShape)bounds).getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (autoroute) {
            if (alpha < -pi + t || alpha > pi - t) {
                xout = x;
                yout = yCenter;
            } else if (alpha < -t) {
                yout = y;
                xout = xCenter;
            } else if (alpha < t) {
                xout = x + width;
                yout = yCenter;
            } else {
                yout = y + height;
                xout = xCenter;
            }
        } else {
            double k = 1.0;
            if (alpha < -pi + t || alpha > pi - t) {
                if (dy < 0.0) {
                    k = -1.0;
                }
                xout = x;
                yout = yCenter + k * Math.abs(width * Math.tan(alpha)) / 2.0;
            } else if (alpha < -t) {
                if (dx < 0.0) {
                    k = -1.0;
                }
                yout = y;
                xout = xCenter + k * Math.abs(height * Math.tan(alpha)) / 2.0;
            } else if (alpha < t) {
                if (dy < 0.0) {
                    k = -1.0;
                }
                xout = x + width;
                yout = yCenter + k * Math.abs(width * Math.tan(alpha)) / 2.0;
            } else {
                if (dx < 0.0) {
                    k = -1.0;
                }
                yout = y + height;
                xout = xCenter + k * Math.abs(height * Math.tan(alpha)) / 2.0;
            }
        }
        return new Point2D.Double(xout, yout);
    }

    Point2D getPerimPoint(Rectangle2D bounds, Point2D p) {
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        double tx = p.getX();
        double ty = p.getY();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Point2D cr = this.lineSegmentIntersection(x, y, x + width, y, cx, cy, tx, ty);
        if (cr != null) {
            return cr;
        }
        cr = this.lineSegmentIntersection(x, y, x, y + height, cx, cy, tx, ty);
        if (cr != null) {
            return cr;
        }
        cr = this.lineSegmentIntersection(x + width, y, x + width, y + height, cx, cy, tx, ty);
        if (cr != null) {
            return cr;
        }
        cr = this.lineSegmentIntersection(x, y + height, x + width, y + height, cx, cy, tx, ty);
        if (cr != null) {
            return cr;
        }
        return cr;
    }

    private Point2D lineSegmentIntersection(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        double t;
        double s;
        double dx1 = p1x - p0x;
        double dy1 = p1y - p0y;
        double dx2 = p3x - p2x;
        double dy2 = p3y - p2y;
        double dx3 = p0x - p2x;
        double dy3 = p0y - p2y;
        double d = dx1 * dy2 - dx2 * dy1;
        if (d != 0.0 && ((s = dx1 * dy3 - dx3 * dy1) <= 0.0 && d < 0.0 && s >= d || s >= 0.0 && d > 0.0 && s <= d) && ((t = dx2 * dy3 - dx3 * dy2) <= 0.0 && d < 0.0 && t > d || t >= 0.0 && d > 0.0 && t < d)) {
            this.collisionDetected = true;
            this.ix = p0x + (t /= d) * dx1;
            this.iy = p0y + t * dy1;
            return new Point2D.Double(this.ix, this.iy);
        }
        return null;
    }

    public void addConnection(Point2D p, TVConnector tvc) {
        this.connMap.put(p, tvc);
    }

    public Point2D getOtherPointAt(Point2D p, TVConnector tvc) {
        for (Map.Entry<Point2D, TVConnector> e : this.connMap.entrySet()) {
            if (e.getValue() == tvc || !(e.getKey().distance(p) < this.pdelta)) continue;
            return e.getKey();
        }
        return null;
    }
}

