/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.util.logging.Logger;

public class MDTransformationManager {
    List transfRegister = new ArrayList();
    HashMap classTransfMap = new HashMap();
    static ClassComparator classComparator = new ClassComparator();
    MetaDataManager mdManager;

    public static void main(String[] args) {
    }

    public MDTransformationManager(MetaDataManager mdManager) {
        this.mdManager = mdManager;
    }

    public void registerTransformer(Class forClass, Class fromObjectTr, Class toObjectTr, Class fromObjectToStreamTr, Class fromObjectToJsonStreamTr, Class fromJsonToObject) {
        TrClassEntry entry = new TrClassEntry();
        entry.fromObject = fromObjectTr;
        entry.toObject = toObjectTr;
        entry.trClass = forClass;
        entry.fromObjectToStream = fromObjectToStreamTr;
        entry.fromObjectToJsonStream = fromObjectToJsonStreamTr;
        entry.fromJsonToObject = fromJsonToObject;
        this.transfRegister.add(entry);
        Collections.sort(this.transfRegister, classComparator);
        int k = 0;
        int l = k++;
    }

    public TrObjects getTransformersFor(Class objectClass) {
        TrObjects tr = (TrObjects)this.classTransfMap.get(objectClass);
        if (tr == null && (tr = this.createTransformers(objectClass)) != null) {
            this.classTransfMap.put(objectClass, tr);
        }
        return tr;
    }

    private TrObjects createTransformers(Class objectClass) {
        ClassDescription cd = this.mdManager.getClassDescription(objectClass.getName());
        TrObjects tr = null;
        if (cd != null) {
            for (TrClassEntry entry : this.transfRegister) {
                if (!entry.trClass.isAssignableFrom(objectClass)) continue;
                tr = new TrObjects();
                tr.transformedClass = entry.trClass;
                try {
                    if (entry.fromObject != null) {
                        tr.fromObject = (MDTransformer)entry.fromObject.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tr.fromObject.init(objectClass, cd, this.mdManager, this);
                    }
                    if (entry.fromObjectToStream != null) {
                        tr.fromObjectToStream = (MDTransformer)entry.fromObjectToStream.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tr.fromObjectToStream.init(objectClass, cd, this.mdManager, this);
                    }
                    if (entry.fromObjectToJsonStream != null) {
                        tr.fromObjectToJsonStream = (MDTransformer)entry.fromObjectToJsonStream.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tr.fromObjectToJsonStream.init(objectClass, cd, this.mdManager, this);
                    }
                    if (entry.fromJsonToObject != null) {
                        tr.fromJsonToObject = (MDTransformer)entry.fromJsonToObject.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tr.fromJsonToObject.init(objectClass, cd, this.mdManager, this);
                    }
                    if (entry.toObject != null) {
                        tr.toObject = (MDTransformer)entry.toObject.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        tr.toObject.init(objectClass, cd, this.mdManager, this);
                    }
                    return tr;
                }
                catch (InstantiationException e) {
                    Logger.error(e);
                }
                catch (IllegalAccessException e) {
                    Logger.error(e);
                }
                catch (IllegalArgumentException e) {
                    Logger.error(e);
                }
                catch (InvocationTargetException e) {
                    Logger.error(e);
                }
                catch (NoSuchMethodException e) {
                    Logger.error(e);
                }
                catch (SecurityException e) {
                    Logger.error(e);
                }
            }
        }
        return tr;
    }

    public MDTransformer getFromObjectTransformerFor(Class objectClass) {
        TrObjects tr = this.getTransformersFor(objectClass);
        if (tr != null) {
            return tr.fromObject;
        }
        return null;
    }

    public MDTransformer getToObjectTransformerFor(Class objectClass) {
        TrObjects tr = this.getTransformersFor(objectClass);
        if (tr != null) {
            return tr.toObject;
        }
        return null;
    }

    public TrObjects getTransformersFor(String className) {
        Class<?> objectClass = null;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
        if (objectClass != null) {
            TrObjects tr = (TrObjects)this.classTransfMap.get(objectClass);
            if (tr == null && (tr = this.createTransformers(objectClass)) != null) {
                this.classTransfMap.put(objectClass, tr);
            }
            return tr;
        }
        return null;
    }

    public MDTransformer getFromObjectTransformerFor(String className) {
        TrObjects tr;
        Class<?> objectClass = null;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
        if (objectClass != null && (tr = this.getTransformersFor(objectClass)) != null) {
            return tr.fromObject;
        }
        return null;
    }

    public MDTransformer getFromMapToStreamTransformerFor(String className) {
        TrObjects tr;
        Class<?> objectClass = null;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
        if (objectClass != null && (tr = this.getTransformersFor(objectClass)) != null) {
            return tr.fromObjectToStream;
        }
        return null;
    }

    public MDTransformer getToObjectTransformerFor(String className) {
        TrObjects tr;
        Class<?> objectClass = null;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Logger.error(e);
        }
        if (objectClass != null && (tr = this.getTransformersFor(objectClass)) != null) {
            return tr.toObject;
        }
        return null;
    }

    public static class ClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof TrClassEntry && o2 instanceof TrClassEntry) {
                Class c1 = ((TrClassEntry)o1).trClass;
                Class c2 = ((TrClassEntry)o2).trClass;
                if (c1.isAssignableFrom(c2) && c2.isAssignableFrom(c1)) {
                    return 0;
                }
                if (c1.isAssignableFrom(c2)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    public class TrObjects {
        MDTransformer fromObjectToStream;
        MDTransformer fromObjectToJsonStream;
        MDTransformer fromJsonToObject;
        MDTransformer fromObject;
        MDTransformer toObject;
        Class transformedClass;

        public MDTransformer getFromObjectTransformer() {
            return this.fromObject;
        }

        public MDTransformer getToObjectTransformer() {
            return this.toObject;
        }

        public Class getTransformedClass() {
            return this.transformedClass;
        }

        public MDTransformer getFromObjectToStreamTransformer() {
            return this.fromObjectToStream;
        }

        public MDTransformer getFromObjectToJsonStreamTransformer() {
            return this.fromObjectToJsonStream;
        }

        public MDTransformer getFromJsonToObjectTransformer() {
            return this.fromJsonToObject;
        }
    }

    class TrClassEntry {
        Class fromObject;
        Class toObject;
        Class fromObjectToStream;
        Class fromObjectToJsonStream;
        Class fromJsonToObject;
        Class trClass;

        TrClassEntry() {
        }
    }
}

