/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;

public class ColumnProxyOraclev9i
extends ColumnProxyOracle {
    public static final String CLOB = "CLOB";
    public static final String OBJECT_RELATIONAL = "OBJECT RELATIONAL";
    public static final String UNLIMITED = "UNLIMITED";
    private static final String[] STORE_AS_CHOICES = new String[]{"CLOB", "OBJECT RELATIONAL"};
    private static Set storeAsSet = null;
    private static final String[] STORAGE_IN_ROW_CHOICES = new String[]{"ENABLE", "DISABLE"};
    private static Set storageInRowSet = null;
    private static final String[] CACHE_CHOICES = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    private static Set cacheSet = null;
    private static final String[] SUBSTITUTABLE_CHOICES = new String[]{"", "YES", "NO", "ONLY FOR TYPE"};
    private static final String[] RETURN_AS_CHOICES = new String[]{"", "VALUE", "LOCATOR"};
    private static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    protected String storeAs = STORE_AS_CHOICES[0];
    protected String lobSegmentName = "";
    protected String xmlSchemaUrl = "";
    protected String xmlSchemaElement = "";
    protected TableSpaceOraclev9i tablespace;
    protected String storageInRow = STORAGE_IN_ROW_CHOICES[0];
    protected String logging = "";
    protected String cache = CACHE_CHOICES[1];
    protected int chunk = 0;
    protected int pctVersion = 0;
    protected long scInitialExtent = 0L;
    protected long scNextExtent = 0L;
    protected int scMinExtents = 1;
    protected String scMaxExtents = "UNLIMITED";
    protected int scPctIncrease = 0;
    protected static Set scBufferPoolSet = null;
    protected String scBufferPool = SC_BUFFER_POOL[0];
    protected int scFreeLists = 1;
    protected int scFreelistGroups = 1;
    protected String oldVersions = OLD_VERSIONS[0];
    protected static Set oldVersionSet = null;
    protected int freepools;
    protected String ntStorageTable = "";
    protected String ntReturn = "";
    protected String lobSegname = "";
    protected String additionalNTS = "";
    protected String elementType = "";
    protected String subtitutable = "";

    public ColumnProxyOraclev9i(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    public static String[] getStoreAsValues() {
        return STORE_AS_CHOICES;
    }

    protected boolean checkStoreAs(String value) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getStoreAsValues()));
        }
        return storeAsSet.contains(value);
    }

    public static String[] getStorageInRowValues() {
        return STORAGE_IN_ROW_CHOICES;
    }

    protected boolean checkStorageInRow(String value) {
        if (storageInRowSet == null) {
            storageInRowSet = new HashSet();
            storageInRowSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getStorageInRowValues()));
        }
        return storageInRowSet.contains(value);
    }

    public static String[] getCacheValues() {
        return CACHE_CHOICES;
    }

    protected boolean checkCache(String value) {
        if (cacheSet == null) {
            cacheSet = new HashSet();
            cacheSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getCacheValues()));
        }
        return cacheSet.contains(value);
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int chunk) {
        this.chunk = chunk;
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int pctVersion) {
        this.pctVersion = pctVersion;
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long scInitialExtent) {
        this.scInitialExtent = scInitialExtent;
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long scNextExtent) {
        this.scNextExtent = scNextExtent;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int scMinExtents) {
        if (scMinExtents >= 1) {
            this.scMinExtents = scMinExtents;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String scMaxExtents) {
        try {
            this.scMaxExtents = Integer.parseInt(scMaxExtents) > 0 ? scMaxExtents : UNLIMITED;
        }
        catch (NumberFormatException E) {
            this.scMaxExtents = UNLIMITED;
        }
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int scPctIncrease) {
        this.scPctIncrease = scPctIncrease;
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String value) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(value);
    }

    public void setSCBufferPool(String value) {
        if (this.checkSCBufferPoolValue(value)) {
            this.scBufferPool = value;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int scFreeLists) {
        if (scFreeLists >= 1) {
            this.scFreeLists = scFreeLists;
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int scFreelistGroups) {
        if (scFreelistGroups >= 1) {
            this.scFreelistGroups = scFreelistGroups;
        }
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    protected boolean checkOldVersion(String value) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getOldVersionChoices()));
        }
        return oldVersionSet.contains(value);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String oldVersions) {
        if (this.checkOldVersion(oldVersions)) {
            this.oldVersions = oldVersions;
            this.fireDataFieldChange();
        }
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int freepools) {
        this.freepools = freepools;
    }

    public String getCache() {
        return this.cache;
    }

    public String getCacheValue() {
        Datatype datatype = this.getDataType();
        if (datatype.toString().equals("XMLTYPE")) {
            return this.cache;
        }
        return null;
    }

    public void setCache(String cache) {
        if (this.checkCache(cache)) {
            this.cache = cache;
            this.fireDataFieldChange();
        }
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String lobSegmentName) {
        this.lobSegmentName = lobSegmentName;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        if (!this.logging.equals(logging) && (ConstantsOracle.checkYesNo(logging) || "".equals(logging))) {
            this.logging = logging;
            this.fireDataFieldChange();
        }
    }

    public String getStoreAs() {
        return this.storeAs;
    }

    public void setStoreAs(String storeAs) {
        if (this.checkStoreAs(storeAs)) {
            this.storeAs = storeAs;
            this.fireDataFieldChange();
        }
    }

    public String getXmlSchemaElement() {
        return this.xmlSchemaElement;
    }

    public void setXmlSchemaElement(String xmlSchemaElement) {
        this.xmlSchemaElement = xmlSchemaElement;
        this.fireDataFieldChange();
    }

    public String getXmlSchemaUrl() {
        return this.xmlSchemaUrl;
    }

    public void setXmlSchemaUrl(String xmlSchemaUrl) {
        this.xmlSchemaUrl = xmlSchemaUrl;
        this.fireDataFieldChange();
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setStorageInRow(String storageInRow) {
        if (this.checkStorageInRow(storageInRow)) {
            this.storageInRow = storageInRow;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOraclev9i getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOraclev9i tablespace) {
        this.tablespace = tablespace;
        this.fireDataFieldChange();
    }

    public static String[] getSubstitutableValues() {
        return SUBSTITUTABLE_CHOICES;
    }

    public static String[] getReturnAsValues() {
        return RETURN_AS_CHOICES;
    }

    public String getAdditionalNTS() {
        return this.additionalNTS;
    }

    public void setAdditionalNTS(String additionalNTS) {
        this.additionalNTS = additionalNTS;
    }

    public String getLobSegname() {
        return this.lobSegname;
    }

    public void setLobSegname(String lobSegname) {
        this.lobSegname = lobSegname;
    }

    public String getNtReturn() {
        return this.ntReturn;
    }

    public void setNtReturn(String ntReturn) {
        this.ntReturn = ntReturn;
    }

    public String getNtStorageTable() {
        return this.ntStorageTable;
    }

    public void setNtStorageTable(String ntStorageTable) {
        this.ntStorageTable = ntStorageTable;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public String getSubtitutable() {
        return this.subtitutable;
    }

    public void setSubtitutable(String subtitutable) {
        this.subtitutable = subtitutable;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyOraclev9i columnProxy = null;
        RelationalObjectProxy storageObject = targetDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyOraclev9i)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setObjectID(this.getObjectID());
            columnProxy.setName(this.getName());
            columnProxy.setDefaultValue(this.getDefaultValue());
            columnProxy.setSubtitutable(this.getSubtitutable());
            columnProxy.setAutoIncrementDDL(this.getAutoIncrementDDL());
            columnProxy.setAutoIncrementUser(this.getAutoIncrementUser());
            columnProxy.setInitially(this.getInitially());
            columnProxy.setDeferrable(this.getDeferrable());
            columnProxy.setEnable(this.getEnable());
            columnProxy.setValidate(this.getValidate());
            columnProxy.setNncName(this.getNncName());
            columnProxy.setNotNullConstraintNameChanged(this.isNotNullConstraintNameChanged());
            columnProxy.setNncDeferrable(this.getNncDeferrable());
            columnProxy.setNncEnable(this.getNncEnable());
            columnProxy.setNncExceptionsTable(this.getNncExceptionsTable());
            columnProxy.setNncInitially(this.getNncInitially());
            columnProxy.setNncRely(this.getNncRely());
            columnProxy.setNncValidate(this.getNncValidate());
            if (this.getExceptionsTable() != null) {
                TableProxyOraclev9i excTable = (TableProxyOraclev9i)targetDesign.getTableProxySet().getProxy(this.getExceptionsTable().getObject().getObjectID());
                if (excTable == null) {
                    TableProxyOraclev9i newExcTable = (TableProxyOraclev9i)((TableProxySetOraclev9i)targetDesign.getTableProxySet()).createProxy(this.getExceptionsTable().getObject());
                    newExcTable.setName(this.getExceptionsTable().getName());
                    newExcTable.setRawObject(true);
                    columnProxy.setExceptionsTable(newExcTable);
                } else {
                    columnProxy.setExceptionsTable(excTable);
                }
            }
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentChanged(this.isCommentChanged());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setCommentInRDBMSChanged(this.isCommentInRDBMSChanged());
            columnProxy.setRawObject(false);
        }
    }
}

