/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerChain;
import oracle.dbtools.crest.model.scheduling.SchedulerChainRule;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerStep;

public class SSBSchedulerChain
extends SQLStatementBuilderScheduler {
    static final List<String> alterProps = new ArrayList<String>();

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("CHAIN_NAME", "CHAIN_NAME");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    static String getAttributeDataType(String name) {
        return "BOOLEAN";
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerChain) {
            SchedulerChain chain = (SchedulerChain)object;
            if (chain.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.CREATE_CHAIN (");
                SSBSchedulerChain.appendObjectName(buffer, chain, prettyPrint);
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerChain.appendStringWithSpace(buffer, ");");
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
                this.appendAtrtributes(buffer, chain, prettyPrint, excludeMap);
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerChain.appendString(buffer, "END");
                SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
                SSBSchedulerChain.appendString(buffer, "/");
                this.appendSteps(buffer, chain, prettyPrint, excludeMap);
                this.appendRules(buffer, chain, prettyPrint, excludeMap);
                SSBSchedulerChain.appendEnableChain(buffer, chain, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerChain.appendStringWithSpace(oldbuffer, "invalid program definitiion for " + String.valueOf(chain.getName() + "\n program type and program action should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerChain.appendString(buffer, "chain_name => '" + obj.getNameFormatted() + "'");
    }

    public static void appendComents(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String comments = obj.getProperty("comments");
        if (comments != null && !comments.isEmpty()) {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "comments => '" + comments + "'");
        }
    }

    public static void appendEnableChain(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.enable(name => '" + name + "');");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendString(buffer, "END");
            SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
            SSBSchedulerChain.appendString(buffer, "/");
        }
    }

    public void appendRules(StringBuffer buffer, SchedulerChain chain, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerChainRule rule : chain.getRules()) {
            this.addChainRule(buffer, chain, rule, prettyPrint);
        }
    }

    public void addChainRule(StringBuffer buffer, SchedulerChain chain, SchedulerChainRule rule, boolean prettyPrint) {
        String cname = rule.getProperty("CHAIN_NAME");
        if (rule.isMinimumDefined() && cname != null && !cname.isEmpty()) {
            String action;
            String cond;
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.DEFINE_CHAIN_RULE (");
            SSBSchedulerChain.appendObjectName(buffer, chain, prettyPrint);
            Object name = rule.getProperty("RULE_NAME");
            if (name != null && !((String)name).isEmpty()) {
                name = SchedulerObject.getFormatedSimpleName((String)name);
                String rowner = rule.getProperty("RULE_OWNER");
                if (rowner != null && !rowner.isEmpty()) {
                    name = SchedulerObject.getFormatedSimpleName(rowner) + "." + (String)name;
                }
                SSBSchedulerChain.appendString(buffer, ',');
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerChain.appendString(buffer, "rule_name => '" + (String)name + "'");
            }
            if ((cond = rule.getProperty("CONDITION")) != null && !cond.isEmpty()) {
                cond = SSBSchedulerChain.replaceSingle_Quote(cond);
                SSBSchedulerChain.appendString(buffer, ',');
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerChain.appendString(buffer, "condition => '" + cond + "'");
            }
            if ((action = rule.getProperty("ACTION")) != null && !action.isEmpty()) {
                action = SSBSchedulerChain.replaceSingle_Quote(action);
                SSBSchedulerChain.appendString(buffer, ',');
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerChain.appendString(buffer, "action => '" + action + "'");
            }
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, ");");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendString(buffer, "END");
            SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
            SSBSchedulerChain.appendString(buffer, "/");
        } else {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "--invalid rule definitiion for chain " + rule.getProperty("CHAIN_NAME") + " rule " + rule.getName() + "\n action and condition should be defined");
        }
    }

    public void appendSteps(StringBuffer buffer, SchedulerChain chain, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerStep step : chain.getSteps()) {
            String type = step.getProperty("STEP_TYPE");
            if (type == null) continue;
            if ("PROGRAM".equalsIgnoreCase(type)) {
                this.addProgramStep(buffer, chain, step, prettyPrint);
                continue;
            }
            if ("SUBCHAIN".equalsIgnoreCase(type)) {
                this.addProgramStep(buffer, chain, step, prettyPrint);
                continue;
            }
            if ("EVENT_SCHEDULE".equalsIgnoreCase(type)) {
                this.addEventScheduleStep(buffer, chain, step, prettyPrint);
                continue;
            }
            if (!"INLINE_EVENT".equalsIgnoreCase(type)) continue;
            this.addInlineEventStep(buffer, chain, step, prettyPrint);
        }
    }

    public void addProgramStep(StringBuffer buffer, SchedulerChain chain, SchedulerStep step, boolean prettyPrint) {
        String pname = step.getProperty("PROGRAM_NAME");
        if (pname != null && !pname.isEmpty()) {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.DEFINE_CHAIN_STEP (");
            SSBSchedulerChain.appendObjectName(buffer, chain, prettyPrint);
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            String st_name = step.getProperty("STEP_NAME");
            st_name = SchedulerObject.getFormatedSimpleName(st_name);
            SSBSchedulerChain.appendString(buffer, "step_name => '" + st_name + "'");
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "program_name => '" + SchedulerObject.getFormatedSimpleName(pname) + "'");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, ");");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            this.appendStepAtrtributes(buffer, chain, step, st_name, prettyPrint, alterProps);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendString(buffer, "END");
            SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
            SSBSchedulerChain.appendString(buffer, "/");
        }
    }

    public void addEventScheduleStep(StringBuffer buffer, SchedulerChain chain, SchedulerStep step, boolean prettyPrint) {
        String sname = step.getProperty("EVENT_SCHEDULE_NAME");
        if (sname != null && !sname.isEmpty()) {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.DEFINE_CHAIN_STEP (");
            SSBSchedulerChain.appendObjectName(buffer, chain, prettyPrint);
            Object name = SchedulerObject.getFormatedSimpleName(sname);
            String sowner = step.getProperty("EVENT_SCHEDULE_OWNER");
            if (sowner != null && !sowner.isEmpty()) {
                name = SchedulerObject.getFormatedSimpleName(sowner) + "." + sname;
            }
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            String st_name = step.getProperty("STEP_NAME");
            st_name = SchedulerObject.getFormatedSimpleName(st_name);
            SSBSchedulerChain.appendString(buffer, "step_name => '" + st_name + "'");
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "event_schedule_name  => '" + (String)name + "'");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, ");");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            this.appendStepAtrtributes(buffer, chain, step, st_name, prettyPrint, alterProps);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendString(buffer, "END");
            SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
            SSBSchedulerChain.appendString(buffer, "/");
        }
    }

    public void addInlineEventStep(StringBuffer buffer, SchedulerChain chain, SchedulerStep step, boolean prettyPrint) {
        String sname = step.getProperty("EVENT_QUEUE_NAME");
        if (sname != null && !sname.isEmpty()) {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendStringWithSpace(buffer, "BEGIN");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.DEFINE_CHAIN_STEP (");
            SSBSchedulerChain.appendObjectName(buffer, chain, prettyPrint);
            Object name = SchedulerObject.getFormatedSimpleName(sname);
            String sowner = step.getProperty("EVENT_QUEUE_OWNER");
            if (sowner != null && !sowner.isEmpty()) {
                name = SchedulerObject.getFormatedSimpleName(sowner) + "." + sname;
            }
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            String st_name = step.getProperty("STEP_NAME");
            st_name = SchedulerObject.getFormatedSimpleName(st_name);
            SSBSchedulerChain.appendString(buffer, "step_name => '" + st_name + "'");
            String cond = step.getProperty("EVENT_CONDITION");
            if (cond != null && !cond.isEmpty()) {
                cond = SSBSchedulerChain.replaceSingle_Quote(cond);
                SSBSchedulerChain.appendString(buffer, ',');
                SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerChain.appendString(buffer, "event_condition => '" + cond + "'");
            }
            SSBSchedulerChain.appendString(buffer, ',');
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "queue_spec => '" + (String)name + "'");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, ");");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            this.appendStepAtrtributes(buffer, chain, step, st_name, prettyPrint, alterProps);
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 0);
            SSBSchedulerChain.appendString(buffer, "END");
            SSBSchedulerChain.appendLineFinisher(buffer, prettyPrint);
            SSBSchedulerChain.appendString(buffer, "/");
        }
    }

    public void appendStepAtrtributes(StringBuffer buffer, SchedulerChain chain, SchedulerStep step, String stepName, boolean prettyPrint, List<String> properties) {
        String chainName = chain.getNameFormatted();
        for (String prop : properties) {
            String def;
            String value = step.getProperty(prop);
            if (value == null || (def = this.getDefaultValue(prop)) != null && def.equalsIgnoreCase(value)) continue;
            String dataType = step.getPropertyDataType(prop);
            SSBSchedulerChain.appendAlterChainAttribute(buffer, chainName, stepName, prop, SSBSchedulerChain.replaceSingle_Quote(value), dataType, prettyPrint);
        }
    }

    private String getDefaultValue(String prop) {
        return "false";
    }

    public static void appendAlterChainAttribute(StringBuffer buffer, String chainName, String stepName, String attribute, String value, String dataType, boolean prettyPrint) {
        if (chainName != null && !chainName.isEmpty() && attribute != null && !attribute.isEmpty()) {
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerChain.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.ALTER_CHAIN(");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "NAME".toLowerCase() + " => '" + chainName + "',");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "step_name => '" + stepName + "',");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerChain.appendString(buffer, "ATTRIBUTE".toLowerCase() + " => '" + attribute + "',");
            SSBSchedulerChain.appendNewLine(buffer, prettyPrint, 2);
            if (value == null) {
                SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => null");
            } else if (dataType != null && !dataType.isEmpty()) {
                String dt = dataType.toUpperCase();
                if (dt.startsWith("VARCHAR") || dt.startsWith("STRING")) {
                    SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => '" + value + "'");
                } else if (dt.startsWith("BOOLEAN") || dt.startsWith("NUMBER")) {
                    SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => " + value);
                } else if (dt.startsWith("TIMESTAMP") && dt.indexOf("WITH") > 0 && dt.indexOf("ZONE") > 0) {
                    SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => TO_TIMESTAMP_TZ('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF TZR')");
                } else if (dt.startsWith("TIMESTAMP")) {
                    SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => TO_TIMESTAMP('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF')");
                } else if (dt.startsWith("INTERVAL")) {
                    SSBSchedulerChain.appendString(buffer, "VALUE".toLowerCase() + " => to_dsinterval('" + value + "')");
                }
            }
            SSBSchedulerChain.appendString(buffer, ");");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerChain;
    }

    static {
        alterProps.add("PAUSE");
        alterProps.add("PAUSED_BEFORE");
        alterProps.add("SKIP");
        alterProps.add("RESTART_ON_FAILURE");
        alterProps.add("RESTART_ON_RECOVERY");
    }
}

