/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.dbtools.core.io.StreamCopy;

public class ZipBuilder {
    public static final int MAX_COMPRESSION = 9;
    private final OutputStream os;
    private final ZipOutputStream zip;
    private final List<String> toc;

    protected ZipBuilder(OutputStream os) {
        this.os = os;
        this.zip = new ZipOutputStream(os);
        this.toc = new ArrayList<String>();
        this.storageMethod(StorageMethod.DEFLATED);
        this.compressionLevel(9);
    }

    public ZipBuilder storageMethod(StorageMethod storageMethod) {
        if (storageMethod == StorageMethod.STORED) {
            this.zip.setMethod(0);
        } else {
            this.zip.setMethod(8);
        }
        return this;
    }

    public ZipBuilder compressionLevel(int level) {
        this.zip.setLevel(level);
        return this;
    }

    private void _addEntry(ZipEntry entry, InputStream stream) throws IOException {
        this.zip.putNextEntry(entry);
        if (stream != null) {
            StreamCopy.drain(stream, this.zip);
        }
        this.zip.closeEntry();
        this.toc.add(entry.getName());
    }

    public ZipBuilder addEntry(String name, InputStream stream) throws IOException {
        this._addEntry(new ZipEntry(name), stream);
        return this;
    }

    public ZipBuilder addEntry(ZipEntry entry, InputStream stream) throws IOException {
        this._addEntry(new ZipEntry(entry), stream);
        return this;
    }

    public String toString() {
        return ZipBuilder.join(this.toc.iterator(), ", ");
    }

    public OutputStream build() throws IOException {
        this.zip.close();
        this.os.flush();
        return this.os;
    }

    private static String join(Iterator<?> iter, String separator) {
        StringBuilder b = new StringBuilder();
        while (iter.hasNext()) {
            Object i = iter.next();
            b.append(i);
            if (!iter.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static enum StorageMethod {
        STORED,
        DEFLATED;

    }
}

