/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.wallet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.DataSourceConfigurator;
import oracle.dbtools.jdbc.wallet.ServiceCredentials;
import oracle.dbtools.jdbc.wallet.WalletException;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public final class AutoLoginWallet
implements DataSourceConfigurator {
    private static final String CONNECT_STRING = "oracle.security.client.connect_string";
    private static final AutoLoginWallet EMPTY = AutoLoginWallet._empty();
    private static final String PASSWORD = "oracle.security.client.password";
    private static final InputOutputStreams STREAMS = InputOutputStreams.instance();
    private static final String USER = "oracle.security.client.username";
    private final transient Set<String> secrets;
    private final transient Map<String, ServiceCredentials> serviceCredentials;
    private final transient SSLContext sslContext;
    private final transient OracleSecretStore store;
    private final transient OracleWallet wallet;

    public static void registerOracklePKI() {
        if (null == Security.getProvider("OraclePKI")) {
            Security.insertProviderAt((Provider)new OraclePKIProvider(), Integer.MAX_VALUE);
        }
    }

    private static AutoLoginWallet _empty() {
        try {
            AutoLoginWallet.registerOracklePKI();
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            return new AutoLoginWallet(wallet, wallet.getSecretStore(), null, Collections.emptySet(), Collections.emptyMap());
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static AutoLoginWallet _read(byte[] bytes) throws IOException {
        try {
            OracleWallet wallet = AutoLoginWallet.readOracleWallet(bytes);
            OracleSecretStore store = wallet.getSecretStore();
            SSLContext sslContext = AutoLoginWallet.sslContext(wallet);
            Set<String> secrets = AutoLoginWallet.secrets(store);
            Map<String, ServiceCredentials> serviceCredentials = AutoLoginWallet.serviceCredentials(wallet);
            return new AutoLoginWallet(wallet, store, sslContext, secrets, serviceCredentials);
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.from(e);
        }
    }

    public static Builder builder(byte[] bytes) throws IOException {
        return new Builder(AutoLoginWallet.readOracleWallet(bytes));
    }

    public static Builder builder() throws WalletException {
        return AutoLoginWallet.empty().modify();
    }

    public static Builder builder(InputStream content) throws WalletException {
        return AutoLoginWallet.empty().modify();
    }

    private static final OracleWallet copy(OracleWallet existing) throws WalletException {
        OracleWallet oracleWallet;
        block8: {
            InputStream payload = existing.getWalletArray(true);
            try {
                OracleWallet duplicate;
                byte[] bytes = STREAMS.asByteArray(payload);
                oracleWallet = duplicate = AutoLoginWallet.readOracleWallet(bytes);
                if (payload == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (payload != null) {
                        try {
                            payload.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw WalletException.from(e);
                }
            }
            payload.close();
        }
        return oracleWallet;
    }

    static AutoLoginWallet empty() {
        return EMPTY;
    }

    public static AutoLoginWallet read(InputStream content) throws IOException {
        byte[] buffered = STREAMS.asByteArray(content);
        return AutoLoginWallet._read(buffered);
    }

    private static OracleWallet readOracleWallet(byte[] payload) throws IOException {
        AutoLoginWallet.registerOracklePKI();
        OracleWallet wallet = new OracleWallet();
        InputStream bufferedStream = STREAMS.asInputStream(payload);
        wallet.setWalletArray(bufferedStream, null);
        return wallet;
    }

    private static Set<String> secrets(OracleSecretStore store) throws WalletException {
        LinkedHashSet<String> secrets = new LinkedHashSet<String>();
        try {
            Enumeration aliases = store.internalAliasesU();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement().toString();
                secrets.add(alias);
            }
            return secrets;
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.from(e);
        }
    }

    private static Map<String, ServiceCredentials> serviceCredentials(OracleWallet wallet) throws WalletException {
        try {
            TreeMap<String, ServiceCredentials> serviceCredentials = new TreeMap<String, ServiceCredentials>(String.CASE_INSENSITIVE_ORDER);
            OracleSecretStore store = wallet.getSecretStore();
            int i = 1;
            boolean check = true;
            while (check) {
                if (store.containsAlias(CONNECT_STRING + i)) {
                    String serviceAlias = new String(store.getSecret(CONNECT_STRING + i));
                    serviceCredentials.put(serviceAlias, new ServiceCredentials(store, i));
                    ++i;
                    continue;
                }
                check = false;
            }
            return serviceCredentials;
        }
        catch (IOException | OracleSecretStoreException e) {
            throw WalletException.from(e);
        }
    }

    private static SSLContext sslContext(OracleWallet wallet) throws WalletException {
        try {
            KeyStore walletKeyStore = wallet.getKeyStore();
            if (walletKeyStore == null || 0 == walletKeyStore.size()) {
                return null;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(walletKeyStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(walletKeyStore, null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw WalletException.from(e);
        }
    }

    private AutoLoginWallet(OracleWallet wallet, OracleSecretStore store, SSLContext sslContext, Set<String> secrets, Map<String, ServiceCredentials> serviceCredentials) {
        this.wallet = wallet;
        this.store = store;
        this.sslContext = sslContext;
        this.serviceCredentials = serviceCredentials;
        this.secrets = secrets;
    }

    public InputStream asInputStream() throws IOException {
        return this.wallet.getWalletArray(true);
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException {
        if (this.sslContext != null) {
            dataSourceBuilder.sslContext(this.sslContext);
            Properties properties = new Properties();
            properties.setProperty("oracle.net.ssl_server_dn_match", "true");
            properties.setProperty("oracle.net.ssl_version", "1.2");
            properties.setProperty("javax.net.ssl.keyStoreType", "SSO");
            dataSourceBuilder.connectionProperties(properties);
        }
    }

    public char[] secret(String alias) throws WalletException {
        try {
            return this.store.getSecret(alias);
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.from(e);
        }
    }

    public Set<String> secrets() {
        return this.secrets;
    }

    ServiceCredentials credentials(String serviceAlias) {
        return this.serviceCredentials.get(serviceAlias);
    }

    public Builder modify() throws WalletException {
        return new Builder(AutoLoginWallet.copy(this.wallet));
    }

    public void write(OutputStream out) throws IOException {
        try (InputStream payload = this.asInputStream();){
            STREAMS.copy(payload, out);
        }
    }

    public static class Builder {
        private final transient KeyStore keyStore;
        private final transient OracleSecretStore store;
        private final transient OracleWallet wallet;

        private Builder(OracleWallet wallet) throws WalletException {
            try {
                this.wallet = wallet;
                this.store = wallet.getSecretStore();
                this.keyStore = wallet.getKeyStore();
            }
            catch (IOException | OracleSecretStoreException e) {
                throw WalletException.from(e);
            }
        }

        public AutoLoginWallet build() throws WalletException {
            try {
                this.wallet.setSecretStore(this.store);
                SSLContext sslContext = AutoLoginWallet.sslContext(this.wallet);
                Set<String> secrets = AutoLoginWallet.secrets(this.store);
                Map<String, ServiceCredentials> serviceCredentials = AutoLoginWallet.serviceCredentials(this.wallet);
                return new AutoLoginWallet(this.wallet, this.store, sslContext, secrets, serviceCredentials);
            }
            catch (IOException | OracleSecretStoreException e) {
                throw WalletException.from(e);
            }
        }

        public int findIndex(String serviceAlias) throws WalletException {
            return this.findIndex(this.store, serviceAlias);
        }

        private int findIndex(OracleSecretStore store, String serviceAlias) throws WalletException {
            try {
                String aliasPrefix = AutoLoginWallet.CONNECT_STRING;
                String expected = serviceAlias;
                Enumeration e = store.internalAliases();
                int index = 1;
                while (e.hasMoreElements()) {
                    String alias = (String)e.nextElement();
                    if (!alias.startsWith(AutoLoginWallet.CONNECT_STRING)) continue;
                    char[] secret = store.getSecret(alias);
                    if (expected.equals(new String(secret))) {
                        return index;
                    }
                    ++index;
                }
                return index;
            }
            catch (OracleSecretStoreException e) {
                throw WalletException.from(e);
            }
        }

        public Builder merge(AutoLoginWallet overrides) throws IOException {
            if (overrides.sslContext != null) {
                try {
                    KeyStore keystore = overrides.wallet.getKeyStore();
                    Enumeration<String> keystoreAliases = keystore.aliases();
                    while (keystoreAliases.hasMoreElements()) {
                        String alias = keystoreAliases.nextElement();
                        Certificate cert = keystore.getCertificate(alias);
                        this.set(alias, cert);
                    }
                }
                catch (KeyStoreException e) {
                    throw WalletException.from(e);
                }
            }
            for (Map.Entry<String, ServiceCredentials> credentials : overrides.serviceCredentials.entrySet()) {
                String serviceAlias = credentials.getKey();
                String user = credentials.getValue().user();
                char[] password = credentials.getValue().password();
                this.set(serviceAlias, user, password);
            }
            return this;
        }

        public Builder set(String alias, Certificate cert) throws WalletException {
            try {
                if (this.keyStore.containsAlias(alias)) {
                    this.keyStore.deleteEntry(alias);
                }
                if (cert != null) {
                    this.keyStore.setCertificateEntry(alias, cert);
                }
                return this;
            }
            catch (KeyStoreException e) {
                throw WalletException.from(e);
            }
        }

        public Builder set(String alias, char[] secret) throws WalletException {
            try {
                if (secret == null) {
                    if (this.store.containsAlias(alias)) {
                        this.store.deleteSecret(alias);
                    }
                } else {
                    this.store.setSecret(alias, secret);
                }
                return this;
            }
            catch (OracleSecretStoreException e) {
                throw WalletException.from(e);
            }
        }

        private Builder set(String prefix, int index, char[] value) throws WalletException {
            if (index > 0) {
                String alias = prefix + index;
                this.set(alias, value);
            }
            return this;
        }

        public Builder set(String serviceAlias, String user, char[] password) throws WalletException {
            int index = this.findIndex(this.store, serviceAlias);
            this.set(AutoLoginWallet.CONNECT_STRING, index, serviceAlias.toCharArray());
            this.set(AutoLoginWallet.USER, index, user.toCharArray());
            this.set(AutoLoginWallet.PASSWORD, index, password);
            return this;
        }
    }
}

