/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ProductConnectDetails;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;

public interface ConnectionHelperFactory {
    public static final ServiceLoader<ConnectionHelperFactory> LOADER = ServiceLoader.load(ConnectionHelperFactory.class);

    public static ConnectionHelper createFallbackHelper() {
        return new ConnectionHelper(){

            @Override
            public Collection<ConnectionHelper.DisplayEntry> getDisplayProperties() {
                return Collections.emptyList();
            }

            @Override
            public void completeConnectionDetails(ProductConnectDetails cd) {
            }

            @Override
            public String getURL() {
                return "";
            }

            @Override
            public String getConnectionSpec() {
                return "";
            }
        };
    }

    public String getConnectionType();

    public ConnectionHelper createConnectionHelper(ConnectionHelperContext var1);

    public static ConnectionHelper findHelper(ConnectionHelperContext ctx) {
        ConnectionHelper helper = null;
        ConnectionDefinition definition = ctx.getDefinition();
        String type = definition.getConnectionType();
        for (ConnectionHelperFactory factory : LOADER) {
            if (!Objects.equals(type, factory.getConnectionType())) continue;
            try {
                helper = factory.createConnectionHelper(ctx);
            }
            catch (Exception ex) {
                ctx.getLogger().logError("Error creating ConnectionHelper", ex);
            }
            break;
        }
        if (helper == null) {
            helper = ConnectionHelperFactory.createFallbackHelper();
        }
        return helper;
    }
}

