/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import oracle.dbtools.connections.api.Connections;

public class ConnectionIdentifiers {
    public static Connections.Identifier createIdentifier(CharSequence charSequence) {
        return ConnectionIdentifier.createIdentifier(charSequence);
    }

    public static Connections.Identifier createUniqueIdentifier() {
        return ConnectionIdentifier.createIdentifier(IdentifierGenerator.getUniqueString());
    }

    private static final class ConnectionIdentifier
    implements Connections.Identifier {
        private final String name;

        static ConnectionIdentifier createIdentifier(CharSequence name) {
            if (name == null) {
                throw new IllegalArgumentException("name");
            }
            return new ConnectionIdentifier(name);
        }

        private ConnectionIdentifier(CharSequence name) {
            this.name = name.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionIdentifier that = (ConnectionIdentifier)o;
            return Objects.equals(this.name, that.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String getConnectionName() {
            return this.name;
        }

        public String toString() {
            return this.getConnectionName();
        }
    }

    private static class IdentifierGenerator {
        private static final SecureRandom entropy = new SecureRandom();
        private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

        private IdentifierGenerator() {
        }

        private static String getUniqueString() {
            byte[] bytes = new byte[16];
            entropy.nextBytes(bytes);
            return encoder.encodeToString(bytes);
        }
    }
}

