/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.ceditor.bookmarks.CodeEditorBookmark;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

final class BookmarkOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "CodeEditorBookmarkOptions";
    private static final String PERSISTED_BOOKMARKS = "persistedBookmarks";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE = "line";

    public BookmarkOptions() {
        this(HashStructure.newInstance());
    }

    private BookmarkOptions(HashStructure hash) {
        super(hash);
    }

    public static BookmarkOptions getInstance(PropertyStorage prefs) {
        return new BookmarkOptions(BookmarkOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public Collection<Bookmark> getPersistedBookmarks() {
        ListStructure list = this._hash.getListStructure(PERSISTED_BOOKMARKS);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        for (Object o : list.toArray()) {
            HashStructure objectHash = (HashStructure)o;
            URL url = objectHash.getURL(PROPERTY_URL);
            int line = objectHash.getInt(PROPERTY_LINE);
            CodeEditorBookmark bookmark = new CodeEditorBookmark(url, line);
            bookmarks.add((Bookmark)bookmark);
        }
        return bookmarks;
    }

    public void setPersistedBookmarks(Collection<Bookmark> bookmarks) {
        ListStructure list = ListStructure.newInstance();
        for (Bookmark bookmark : bookmarks) {
            if (!(bookmark instanceof CodeEditorBookmark)) continue;
            HashStructure objectHash = HashStructure.newInstance();
            objectHash.putURL(PROPERTY_URL, ((CodeEditorBookmark)bookmark).getURL());
            objectHash.putInt(PROPERTY_LINE, ((CodeEditorBookmark)bookmark).getLine());
            list.add((Object)objectHash);
        }
        this._hash.putListStructure(PERSISTED_BOOKMARKS, list);
    }
}

