/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.searchbar;

import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.searchbar.Provider;
import oracle.javatools.icons.OracleIcons;

public final class Result<T> {
    private final Provider provider;
    private final T data;
    private final String displayText;
    private final String displayLocation;
    private final Icon displayIcon;
    private final Map<String, Object> extraProperties;
    private final int weight;

    private Result(Provider provider, T data, String displayText, Icon displayIcon, String displayLocation, Map<String, Object> extraProperties, int weight) {
        this.provider = provider;
        this.data = data;
        this.displayText = displayText;
        this.displayLocation = displayLocation;
        this.displayIcon = displayIcon;
        this.extraProperties = Collections.unmodifiableMap(extraProperties);
        this.weight = weight;
    }

    public Provider provider() {
        return this.provider;
    }

    public T data() {
        return this.data;
    }

    public String displayText() {
        return this.displayText;
    }

    public String displayLocation() {
        return this.displayLocation;
    }

    public Icon displayIcon() {
        return this.displayIcon;
    }

    public Map<String, Object> extraProperties() {
        return this.extraProperties;
    }

    public int weight() {
        return this.weight;
    }

    public void open() {
        this.provider().open(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Result) {
            return this.data.equals(((Result)o).data);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static class ResultBuilder<T> {
        private final Provider provider;
        private final T data;
        private String displayText;
        private String displayLocation;
        private Icon displayIcon;
        private Map<String, Object> extraProperties = Collections.emptyMap();
        private int weight;

        public ResultBuilder(Provider provider, T data) {
            this.provider = provider;
            this.data = data;
            this.displayText = data.toString();
            this.displayLocation = null;
            this.displayIcon = OracleIcons.getIcon((String)"file.png");
        }

        public ResultBuilder displayText(String text) {
            this.displayText = text;
            return this;
        }

        public ResultBuilder displayLocation(String location) {
            this.displayLocation = location;
            return this;
        }

        public ResultBuilder displayIcon(Icon displayIcon) {
            this.displayIcon = displayIcon;
            return this;
        }

        public ResultBuilder extraProperties(Map<String, Object> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public ResultBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.provider, this.data, this.displayText, this.displayIcon, this.displayLocation, this.extraProperties, this.weight);
        }
    }
}

